#ifndef ALTBASEKEY_H
#define ALTBASEKEY_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id$

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altBaseKey.h
 * \brief   Base Class
 * \date    2007
 * \author  NEKO SYSTEM
 */

/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altMisc/altProperty.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  base key class
///
class altBaseKey : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altBaseKey();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altBaseKey();

  ///
  /// \brief  Create Key File
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t CreateKeyFile();

  ///
  /// \brief  Create Property File
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Create();

  ///
  /// \brief  Load Property File
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_KEY_FILE  error
  ///
  LIBALT_API alt_t DecodeLoad();

private:
  altProperty m_oKeyFile;
};

#endif
