#ifndef ALTCOMMON_H
#define ALTCOMMON_H
/*--------------------------------------------------------------------------*

   Alternative Library

  $Id: altCommon.h 1425 2009-09-08 21:15:17Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altCommon.h
 * \brief   Alternative Library Common Header
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#ifdef __cplusplus
#  define  ALT_BEGIN_C_DECLS extern "C" {
#  define  ALT_END_C_DECLS }
#else  /* __cplusplus */
#  define  ALT_BEGIN_C_DECLS
#  define  ALT_END_C_DECLS
#endif  /* __cplus_plus */

#ifdef WIN32
  #define ALT_WIN
  #define alloca _alloca
  #if defined(ALT_DOTNET)
    #define ALT_APIENTRY 
    #define LIBALT_API
  #elif defined(ALTDLL)
    #ifdef LIBALT_EXPORTS
      #define LIBALT_API __declspec(dllexport)
    #else
      #define LIBALT_API __declspec(dllimport)
    #endif
    #define ALT_APIENTRY APIENTRY
  #else
    #define LIBALT_API
    #define ALT_APIENTRY APIENTRY
  #endif
#else
  #define ALT_LINUX
  #define LIBALT_API
  #define _ISOC99_SOURCE
#endif

///
/// \brief  Get array size
///
/// \param  p [I ] array
///
/// \return array size
///
#define ALT_ARRAY_SIZE(p) (sizeof (p) / sizeof (* p))

#define ALT_BUFSIZ    2048    ///< Buffer Size

/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <stdio.h>
#include <assert.h>

#ifdef ALT_WIN
  #include <winsock2.h>
  #include <windows.h>
  #include <tchar.h>
#endif

#ifdef ALT_LINUX
  #include <sys/types.h>
  #include <unistd.h>
  #include <string.h>
  #include <wctype.h>
  #include <wchar.h>
  #include <errno.h>
  #include <stdlib.h>
#endif

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef char                altChar;
typedef unsigned char       altUChar;
typedef unsigned char       altByte;
typedef bool                altBool;

typedef short               altShort;
typedef unsigned short      altUShort;

typedef int                 altInt;
typedef unsigned int        altUInt;

typedef long                altLong;
typedef unsigned long       altULong;

typedef long long           altLongLong;
typedef unsigned long long  altULongLong;

#ifdef ALT_LINUX
  typedef unsigned short    WORD;
  typedef unsigned long     DWORD;
  typedef unsigned char     BYTE;
#endif

typedef float               altFloat;
typedef double              altDouble;

typedef altUShort           altWChar;

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#ifdef _DEBUG
  #define ALT_BASE_ASSERT(cond) assert (cond)
#else
  #define ALT_BASE_ASSERT(cond)
#endif

#ifdef ALT_LINUX
  #define INFINITE  0xFFFFFFFF
#endif

#ifdef ALT_WIN
  #define ALT_THROWS(exception) 
#endif

#ifdef ALT_LINUX
  #define ALT_THROWS(exception) throw (exception)
  #define _T(text) L##text
#endif


#ifdef _DEBUG
#define USE_MEM_MANAGER_FULL
#endif

#endif  // ALTCOMMON_H

