#ifndef ALTEXTERNALIZABLE_H
#define ALTEXTERNALIZABLE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altExternalizable.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altExternalizable.h
 * \brief   Externalizable
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altDataStream.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altDataStream;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Data Stream
///
class altExternalizable : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altExternalizable();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altExternalizable();

  ///
  /// \brief  Write
  ///
  /// \param  oDataStream [ O] Data stream
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t virtual Write(altDataStream & oDataStream) const = 0;
  
  ///
  /// \brief  Read
  ///
  /// \param  oDataStream [I ] Data stream
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t virtual Read(altDataStream & oDataStream) const = 0;
};

#endif
