#ifndef ALTMEMINFO_H
#define ALTMEMINFO_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altMemInfo.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altMemInfo.h
 * \brief   Memory Infomation
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

#include <sys/timeb.h>
#include <string>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define	ALT_MEM_GARBEGE  0xCC  ///< garbege

/*----------------------------------------------------------------*
  Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  memory management infomation manager
///
class altMemInfo
{
public:
  ///
  /// \brief  Constructor
  ///
  altMemInfo();

  ///
  /// \brief  Destructor
  ///
  virtual ~altMemInfo();

  ///
  /// \brief  Init Memory Infomation
  ///
  /// \param  nSize       [I ] memory size
  /// \param  szFileName  [I ] file name
  /// \param  nLine       [I ] file line number
  ///
  void Init(const altUInt nSize, const altChar * szFileName, const altUInt nLine);

  ///
  /// \brief  Write memory infomation
  ///
  /// \param  pPtr  [IO] pointer of real memory
  ///
  void Write(void * pPtr) const;

  ///
  /// \brief  Read Memory Infomation
  ///
  /// \param  pRealPtr  [I ] pointer of real memory
  ///
  void Read(const altChar * pRealPtr);

  ///
  /// \brief  Get memory size
  ///
  /// \return memory size
  ///
  altUInt GetSize() const;

  ///
  /// \brief  Get memory infomation block size
  ///
  /// \return memory infomation block size
  ///
  altUInt GetInfoSize() const;
  
  ///
  /// \brief  Get memory real size
  ///
  /// \return memory real size
  ///
  altUInt GetRealSize() const;

  ///
  /// \brief  check over write memory detected
  ///
  /// \return true  detected
  /// \return false not detected
  ///
  altBool OverWriteDetected() const;

  altUChar        m_cMagic;               ///< magic number
  altUInt         m_nSize;                ///< allocated size
#ifdef USE_MEM_MANAGER_FULL
  altUInt         m_nFileNameSize;        ///< allocated filename size
  std::string     m_szFileName;           ///< allocated filename
  altUInt         m_nLine;                ///< allocated line number
  struct timeb    m_oTime;                ///< allocated time
#endif
  const altChar * m_pAddr;                ///< allocated address

  static const altUChar ALT_MEM_MAGIC;    ///< memory magic number
  static const altUChar ALT_MEM_END_SIG;  ///< memory magic number
};

#endif

