/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSignal.cpp 1368 2008-04-25 06:02:50Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSignal.cpp
 * \brief   Signal
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSignal.h"
#ifdef ALT_LINUX
#include "altStr.h"
#include <errno.h>

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altSignal::altSignal()
{
}

///
/// \brief  Destructor
///
LIBALT_API altSignal::~altSignal()
{
}

///
/// \brief  Signal block
///
/// \param  nSignal [I ] Signal Number
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altSignal::Block(const altInt nSignal)
{
  struct sigaction  oAction;
  struct sigaction  oOldAction;

  memset (& oAction, 0x00, sizeof (oOldAction));
  memset (& oOldAction, 0x00, sizeof (oOldAction));

  oAction.sa_handler = altSignal::BlockHandler;

  altInt  nRet = sigaction (nSignal, & oAction, & oOldAction);
  if (nRet < 0) {
    altInt  nErrNo = errno;
    altStr  sBuf;
    ALT_RET_P (ALT_E_ERROR, sBuf.Format ("%d:%s", nErrNo, strerror (nErrNo)));
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Signal ignore
///
/// \param  nSignal [I ] Signal Number
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altSignal::Ignore(const altInt nSignal)
{
  signal (nSignal, SIG_IGN);
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Signal block handler
///
/// \param  nSignal [I ] Signal number
///
LIBALT_API void altSignal::BlockHandler(const int nSignal)
{
}

#endif
