#ifndef ALTSIGNAL_H
#define ALTSIGNAL_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSignal.h 1366 2008-04-25 05:33:50Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSignal.h
 * \brief   Signal
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_LINUX
#include <altBase/altLog.h>
#include <signal.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Signal
///
class altSignal : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSignal();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSignal();

  ///
  /// \brief  Signal block
  ///
  /// \param  nSignal [I ] Signal Number
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API static alt_t Block(const altInt nSignal);

  ///
  /// \brief  Signal ignore
  ///
  /// \param  nSignal [I ] Signal Number
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API static alt_t Ignore(const altInt nSignal);

  ///
  /// \brief  Signal block handler
  ///
  /// \param  nSignal [I ] Signal number
  ///
  LIBALT_API static void BlockHandler(const int nSignal);
};

#endif
#endif
