#ifndef ALTSINGLETON_H
#define ALTSINGLETON_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSingleton.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSingleton.h
 * \brief   Singleton Base Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBase.h>
#include <altBase/altSyncThread.h>
#include <altBase/altUncopyable.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Singleton Base
///
template <typename T>
class altSingleton : public altBase, private altUncopyable
{
protected:
  ///
  /// \brief  Constructor
  ///
  altSingleton(){};
  
  ///
  /// \brief  Destructor
  ///
  virtual ~altSingleton(){};

public:
  ///
  /// \brief	Get instance
  ///
  /// \return instance
  ///
	static T & GetInstance()
  {
    if (pInstance == NULL) {
      oSyncThread.BeginLock();
      if (pInstance == NULL) {
        pInstance = new T();
      }
      oSyncThread.EndLock();
    }
    return (* pInstance);
  };

  ///
  /// \brief  Delete instance
  ///
  static void DeleteInstance()
  {
    if (pInstance != NULL) {
      delete pInstance;
      pInstance = NULL;
    }
  };

protected:
	static T *		          pInstance;	    ///< instance
  static altSyncThread    oSyncThread;    ///< sync thread
};

template<typename T> T *           altSingleton<T>::pInstance = NULL;  ///< instance
template<typename T> altSyncThread altSingleton<T>::oSyncThread;       ///< sync thread

#endif  // ALTSINGLETON_H

