#ifndef ALTSYNCTHREAD_H
#define ALTSYNCTHREAD_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSyncThread.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSyncThread.h
 * \brief   thread sync
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

#ifdef ALT_LINUX
  #include <pthread.h>
#endif

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Thread Sync
///
class altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSyncThread();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSyncThread();

  ///
  /// \brief  Begin Lock
  ///
  LIBALT_API void BeginLock() const;

  ///
  /// \brief  End Lock
  ///
  LIBALT_API void EndLock() const;

  ///
  /// \brief  Wait Signal
  ///
  /// \param  dwTimeout   [I ] timeout(msec) (default value is no timeout)
  ///
  void WaitSignal(DWORD dwTimeout = INFINITE) const;

	///
	/// \brief	Set Signal
	///
	void SetSignal() const;

private:
#ifdef ALT_WIN
  mutable CRITICAL_SECTION  m_oCriticalSection;
  mutable HANDLE            m_oEvent;
#else
  mutable pthread_mutex_t   m_oMutex;
  mutable pthread_cond_t    m_oCond;
#endif
};

#endif  // ALTSYNCTHREAD_H

