/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altThread.cpp 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altThread.cpp
 * \brief   thread
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altThread.h"

#ifdef ALT_WIN
  #include <process.h>
#else
  #include <pthread.h>
#endif

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altThread::altThread()
{
}

///
/// \brief  Destructor
///
LIBALT_API altThread::~altThread()
{
}

///
/// \brief  Start thread
///
LIBALT_API void altThread::Start(altThreadFunc pFunc, void * pParam)
{
#ifdef ALT_WIN
  _beginthread (pFunc, 0, pParam);
#else
  pthread_t oThread;
  altInt nRet = pthread_create (& oThread, NULL, pFunc, pParam);
  if (nRet != 0) {
    // error
  }
#endif
}

