#ifndef ALTTHREAD_H
#define ALTTHREAD_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altThread.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altThread.h
 * \brief   thread
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBase.h>
#include <altBase/altUncopyable.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#ifdef ALT_WIN
  #define ALT_THREAD  void
#else
  #define ALT_THREAD  void *
#endif

#ifdef ALT_WIN
  #define ALT_THREAD_END(p) return
#else
  #define ALT_THREAD_END(p) return (p)
#endif

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef ALT_THREAD (* altThreadFunc)(void *);

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Thread
///
class altThread : public altBase, private altUncopyable
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altThread();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altThread();

  ///
  /// \brief  Start thread
  ///
  /// \param  pFunc   [I ] thread funciton
  /// \param  pParam  [I ] thread function parameter
  ///
  LIBALT_API virtual void Start(altThreadFunc pFunc, void * pParam);
};

#endif  // ALTTHREAD_H

