#ifndef ALTUTIL_H
#define ALTUTIL_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altUtil.h 1414 2008-10-24 20:41:25Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altUtil.h
 * \brief   Utility Function
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

#include <stdarg.h>

/*----------------------------------------------------------------*
 * Function Declare
 *----------------------------------------------------------------*/
/**
 * \brief compare string
 *
 * \param szStr1  [! ] string 1
 * \param szStr2  [I ] string 2
 *
 * \return  1   szStr1 > szStr2
 * \return  0   szStr1 = szStr2
 * \return  -1  szStr1 < szStr2
 */
LIBALT_API altInt altStrcmp (
  altChar *       szStr1,
  const altChar * szStr2
);


/**
 * \brief copy string
 *
 * \param pDst  [ O] output
 * \param pSrc  [I ] source string
 * \param nSize [I ] string size
 */
LIBALT_API void altStrncpy (
  altChar *       pDst,
  const altChar * pSrc,
  const altUInt   nSize
);


/**
 * \brief add string
 *
 * \param pDst      [ O] output
 * \param nDstSize  [I ] output buffer size
 * \param pSrc      [I ] source string
 * \param nSize     [I ] string size
 */
LIBALT_API void altStrncat (
  altChar *       pDst,
  const altUInt   nDstSize,
  const altChar * pSrc,
  const altUInt   nSize
);


/**
 * \brief format string
 *
 * \param pBuf      [IO] buffer
 * \param nBufSize  [I ] buffer size
 * \param szFormat  [I ] format
 * \param oArgs     [I ] arguments
 *
 * \return  string length
 */
LIBALT_API const altInt altVsnprintf (
  altChar *       pBuf,
  const altUInt   nBufSize,
  const altChar * szFormat,
  va_list &       oArgs
);


/**
 * \brief format string
 *
 * \param pBuf      [IO] buffer
 * \param nBufSize  [I ] buffer size
 * \param szFormat  [I ] format
 * \param oArgs     [I ] arguments
 *
 * \return  string length
 */
LIBALT_API const altInt altVswnprintf (
  altWChar *        pBuf,
  const altUInt     nBufSize,
  const wchar_t *   szFormat,
  va_list &         oArgs
);


/**
 * \brief sleep
 *
 * \param msec  [I ] sleep miliseconds
 */
LIBALT_API void altSleep (
  const DWORD msec
);


/**
 * \brief create directory
 *
 * \param szDirName  [I ] directory name
 *
 * \return true   success
 * \return false  error
 */
LIBALT_API const altBool altMkDir (
  const altChar * szDirName
);


/**
 * \brief create directory recursive
 *
 * \param szDirName  [I ] directory name
 *
 * \return true   success
 * \return false  error
 */
LIBALT_API const altBool altMkDirR (
  const altChar * szDirPath
);

///
/// \brief	open file
///
/// \param	pFile		    [ O] pointer of file stream
/// \param	szFileName	[I ] file name
/// \param	szMode		  [I ] open mode
///
void altFOpen (
  FILE * &        pFile,
  const altChar * szFileName,
  const altChar * szMode
);

///
/// \brief	open file
///
/// \param	pFile		    [ O] pointer of file stream
/// \param	szFileName	[I ] file name
/// \param	szMode		  [I ] open mode
///
void altFOpen (
  FILE * &          pFile,
  const altWChar *  szFileName,
  const altWChar *  szMode
);

///
/// \brief  Get wide string length
///
/// \param  szWStr  [I ] Wide string
///
/// \return Wide string length
///
altUInt altWStrLen (
  const altWChar *  szWStr
);


/**
 * \brief Copy wide string
 *
 * \param pDst  [ O] output
 * \param pSrc  [I ] source string
 * \param nSize [I ] string size
 */
LIBALT_API void altWStrncpy (
  altWChar *        pDst,
  const altWChar *  pSrc,
  const altUInt     nSize
);

#endif

