/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBConnection.cpp 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBConnection.cpp
 * \brief   DB Connection Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDBConnection.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDBConnection::altDBConnection()
{
}

///
/// \brief  Destructor
///
LIBALT_API altDBConnection::~altDBConnection()
{
  alt_t status = ClearPreparedStatementCache();
  ALT_LOG (status);
}

///
/// \brief  Set Explain Log
///
/// \param  bEnable [I ] Enable or not
/// \param  sLogDir [I ] Explain Log Directory
///
/// \return ALT_S_SUCCESS   success
///
LIBALT_API alt_t altDBConnection::SetExplainLog(altBool bEnable, const altStr & sLogDir)
{
  m_bExplainLogEnable = bEnable;
  m_bExplainLogDir = sLogDir;
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Clear Prepared Statement Cache
///
/// \return ALT_S_SUCCESS Success
///
LIBALT_API alt_t altDBConnection::ClearPreparedStatementCache()
{
  for (altPreparedStatementMap::iterator i = m_oPreparedStatementMap.begin(); i != m_oPreparedStatementMap.end(); i++) {
    delete i->second;
    i->second = NULL;
  }
  m_oPreparedStatementMap.clear();
  ALT_RET (ALT_S_SUCCESS);
}


