#ifndef ALTDBCONNECTIONPTR_H
#define ALTDBCONNECTIONPTR_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBConnectionPtr.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBConnectionPtr.h
 * \brief   DB Connection Pointer Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBConnection.h>
#include <altDB/altDBManager.h>

class altDBManager;
/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DB Connection Pointer
///
class altDBConnectionPtr : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDBConnectionPtr();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDBConnectionPtr();

  ///
  /// \brief  Set Pointer
  ///
  /// \param  pDBConnection   [I ] Pointer of DB Connection
  /// \param  pDBManager      [I ] Pointer of DB Manager
  ///
  LIBALT_API alt_t Set(altDBConnection * pDBConnection, altDBManager * pDBManager);

  ///
  /// \brief  operator ->
  ///
  /// \return Pointer of DB Connection
  ///
  LIBALT_API altDBConnection * operator -> () const;

  ///
  /// \brief  Get DB connection
  ///
  /// \return DB connection
  ///
  LIBALT_API altDBConnection & Get() const;

private:
  altDBConnection *   m_pDBConnection;
  altDBManager *      m_pDBManager;
};

#endif //ALTDBCONNECTIONPTR_H
