#ifndef ALTDBMANAGER_H
#define ALTDBMANAGER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBManager.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBManager.h
 * \brief   DB Connection Manager Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBConnectionPtr.h>
#include <altBase/altSyncThread.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
///
/// \brief  Data Base Type
///
enum altDBTypes {
  ALT_DB_TYPE_MYSQL = 0,    ///< MySQL
};

typedef std::vector<altDBConnection *> altDBConnectionContainer;

class altDBConnectionPtr;
/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DB Connection Manager
///
class altDBManager : public altBase, private altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  nDBType   [I ] DB Type
  ///
  LIBALT_API altDBManager(const altDBTypes nDBType);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDBManager();

  ///
  /// \brief  Initialize
  ///
  /// \param  sHost       [I ] DB Host Name
  /// \param  nPort       [I ] DB Port Number
  /// \param  sDB         [I ] DB Name
  /// \param  sUser       [I ] DB User ID
  /// \param  sPasswd     [I ] DB Password
  /// \param  sCharset    [I ] DB Character Set
  /// \param  bAutoCommit [I ] Auto commit or not
  /// \param  nPool       [I ] DB Connection Pool Count
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t Init(const altStr & sHost, const altInt nPort, const altStr & sDB, const altStr & sUser, const altStr & sPasswd, const altStr & sCharset, const altBool bAutoCommit, const altUInt nPool);

  ///
  /// \brief  Get DB Connection
  ///
  /// \param  pDBConnection [ O] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t GetDBConnection(altDBConnectionPtr & pDBConnection);

  ///
  /// \brief  Release DB Connection
  ///
  /// \param  pDBConneection  [IO] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t ReleaseDBConnection(altDBConnection * & pDBConnection);

private:
  ///
  /// \brief  Get DB Connection
  ///
  /// \param  pDBConnection [ O] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t GetDBConnection(altDBConnection * & pDBConnection);

  ///
  /// \brief  Create DB Connection
  ///
  /// \param  pDBConnection [ O] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t CreateDBConnection(altDBConnection * & pDBConnection);

  altDBTypes                m_nDBType;        ///< DB Type
  altDBConnectionContainer  m_oConnections;   ///< DB Connection Container
};

#endif //ALTDBMANAGER_H
