/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBResultSet.cpp 1386 2008-04-28 21:14:05Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBResultSet.cpp
 * \brief   DB Result Set Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDBResultSet.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDBResultSet::altDBResultSet()
{
}

///
/// \brief  Destructor
///
LIBALT_API altDBResultSet::~altDBResultSet()
{
}

///
/// \brief  Add Row
///
/// \param  oRow  [I ] Row Data
///
/// \return ALT_S_SUCCESS
///
LIBALT_API alt_t altDBResultSet::Add(const altDBRow * pRow)
{
  m_oResultData.push_back (pRow);
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Size
///
/// \return Row Count
///
LIBALT_API altUInt altDBResultSet::Size() const
{
  return ((altUInt)m_oResultData.size());
}

///
/// \brief  [] operator
///
/// \param  nIndex [I ] index
///
/// \return Row Data of index position
///
LIBALT_API const altDBRow & altDBResultSet::operator [](const altUInt nIndex) const ALT_THROWS (alt_t)
{
  if (nIndex >= Size()) {
    altStr sBuf;
    ALT_LOG_P (ALT_E_OUT_OF_INDEX, sBuf.Format ("[%u] >= [%u]", nIndex, Size()));
    throw (ALT_E_OUT_OF_INDEX);
  }
  return (* m_oResultData[nIndex]);
}

///
/// \brief  Clear
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altDBResultSet::Clear()
{
  for (altUInt i = 0; i < m_oResultData.size(); i++) {
    delete m_oResultData[i];
  }
  m_oResultData.clear();
  ALT_RET (ALT_S_SUCCESS);
}

