#ifndef ALTDBRESULTSET_H
#define ALTDBRESULTSET_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBResultSet.h 1386 2008-04-28 21:14:05Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBResultSet.h
 * \brief   DB Result Set Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBRow.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<const altDBRow *> altResultContainer; ///< DB Record Container

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Result Set
///
class altDBResultSet : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDBResultSet();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDBResultSet();

  ///
  /// \brief  Add Row
  ///
  /// \param  oRow  [I ] Row Data
  ///
  /// \return ALT_S_SUCCESS
  ///
  LIBALT_API alt_t Add(const altDBRow * pRow);

  ///
  /// \brief  Get Size
  ///
  /// \return Row Count
  ///
  LIBALT_API altUInt Size() const;

  ///
  /// \brief  [] operator
  ///
  /// \param  nIndex [I ] index
  ///
  /// \return Row Data of index position
  ///
  LIBALT_API const altDBRow & operator [](const altUInt nIndex) const ALT_THROWS (alt_t);

  ///
  /// \brief  Clear
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Clear();

private:
  altResultContainer  m_oResultData;  ///< DB Result Set Data
};

#endif //ALTDBRESULTSET_H

