/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBRow.cpp 1126 2008-04-03 03:27:48Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBRow.cpp
 * \brief   DB Result Row Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDBRow.h"

#include "altBase/altMem.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDBRow::altDBRow() :
m_oDataList(),
m_oDataMap(),
m_oDataSizeMap()
{
}

///
/// \brief  Destructor
///
LIBALT_API altDBRow::~altDBRow()
{
  for (altUInt i = 0; i < m_oDataList.size(); i++) {
    ALT_FREE (m_oDataList[i]);
  }
  m_oDataList.clear();
  m_oDataMap.clear();
}

///
/// \brief  Add Column
///
/// \param  sColumnName [I ] Column Name
/// \param  sValue      [I ] Column Value
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_NOMEM     out of memory
///
LIBALT_API alt_t altDBRow::Add(const altStr & sColumnName, const altStr & sValue)
{
  alt_t     status;
  altChar * pBuf = NULL;

  status = ALT_STRALLOC (pBuf, sValue.GetCStr());

  m_oDataList.push_back (pBuf);
  m_oDataMap[sColumnName] = pBuf;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Add Column
///
/// \param  sColumnName [I ] Column Name
/// \param  pValue      [I ] Column Value
/// \param  nValueSize  [I ] Column Value Size
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_NOMEM     out of memory
///
LIBALT_API alt_t altDBRow::AddStr(const altStr & sColumnName, altChar * pValue, const altUInt nValueSize)
{
  altChar * pBuf = NULL;
  alt_t     status;

  status = ALT_MALLOC (pBuf, nValueSize + sizeof (altWChar));
  ALT_ERR_RET (status);
  memcpy (pBuf, pValue, nValueSize);

  m_oDataList.push_back (pBuf);
  m_oDataMap[sColumnName] = pBuf;
  m_oDataSizeMap[sColumnName] = nValueSize;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Add Column
///
/// \param  sColumnName [I ] Column Name
/// \param  pValue      [I ] Column Value
/// \param  nValueSize  [I ] Column Value Size
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_NOMEM     out of memory
///
LIBALT_API alt_t altDBRow::Add(const altStr & sColumnName, altChar * pValue, const altUInt nValueSize)
{
  altChar * pBuf = NULL;
  alt_t     status;

  if (nValueSize > 0) {
    status = ALT_DUPALLOC (pBuf, pValue, nValueSize);
    ALT_ERR_RET (status);
  }

  m_oDataList.push_back (pBuf);
  m_oDataMap[sColumnName] = pBuf;
  m_oDataSizeMap[sColumnName] = nValueSize;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Size
///
/// \return Row Count
///
LIBALT_API altUInt altDBRow::Size() const
{
  return ((altUInt)m_oDataList.size());
}

///
/// \brief  [] operator
///
/// \param  nIndex [I ] index
///
/// \return Column Value
///
LIBALT_API altChar * altDBRow::operator [](const altUInt nIndex) const ALT_THROWS (alt_t)
{
  if (nIndex >= Size()) {
    altStr sBuf;
    ALT_LOG_P (ALT_E_OUT_OF_INDEX, sBuf.Format ("[%u] >= [%u]", nIndex, Size()));
    throw (ALT_E_OUT_OF_INDEX);
  }
  return (m_oDataList[nIndex]);
}

///
/// \brief  [] operator
///
/// \param  sColumnName [I ] Column Name
///
/// \return Column Value
///
LIBALT_API altChar * altDBRow::operator [](const altStr & sColumnName) const
{
  return (m_oDataMap[sColumnName]);
}

///
/// \brief  Get data size
///
/// \param  sColumnName [I ] Column Name
///
/// \return Data size
///
LIBALT_API altUInt altDBRow::GetDataSize(const altStr & sColumnName) const
{
  return (m_oDataSizeMap[sColumnName]);
}

///
/// \brief  Get int
///
/// \param  nIndex [I ] index
/// 
/// \return Column Value
///
LIBALT_API altInt altDBRow::GetInt(const altUInt nIndex) const
{
  altInt  nRet;
  memcpy (& nRet, m_oDataList[nIndex], sizeof (nRet));
  return (nRet);
}

///
/// \brief  Get int
///
/// \param  sColumnName [I ] Column Name
/// 
/// \return Column Value
///
LIBALT_API altInt altDBRow::GetInt(const altStr & sColumnName) const
{
  altInt  nRet;
  memcpy (& nRet, m_oDataMap[sColumnName], sizeof (nRet));
  return (nRet);
}

///
/// \brief  Get altUInt
///
/// \param  nIndex [I ] index
/// 
/// \return Column Value
///
LIBALT_API altUInt altDBRow::GetUInt(const altUInt nIndex) const
{
  altUInt  nRet;
  memcpy (& nRet, m_oDataList[nIndex], sizeof (nRet));
  return (nRet);
}

///
/// \brief  Get altUInt
///
/// \param  sColumnName [I ] Column Name
/// 
/// \return Column Value
///
LIBALT_API altUInt altDBRow::GetUInt(const altStr & sColumnName) const
{
  altUInt  nRet;
  memcpy (& nRet, m_oDataMap[sColumnName], sizeof (nRet));
  return (nRet);
}
