#ifndef ALTDBROW_H
#define ALTDBROW_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBRow.h 1126 2008-04-03 03:27:48Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBRow.h
 * \brief   DB Result Row Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStr.h>
#include <altBase/altStatus.h>
#include <altBase/altLog.h>
#include <altBase/altBase.h>

#include <vector>
#include <map>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<altChar *>      altRowContainer;  ///< Result Row Data Container
typedef std::map<altStr, altChar *> altRowMap;        ///< Result Row Data Map
typedef std::map<altStr, altUInt>   altRowSizeMap;    ///< Result Row Data Size Map

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Result Record Row
///
class altDBRow : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDBRow();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDBRow();

  ///
  /// \brief  Add Column
  ///
  /// \param  sColumnName [I ] Column Name
  /// \param  sValue      [I ] Column Value
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_NOMEM     out of memory
  ///
  LIBALT_API alt_t Add(const altStr & sColumnName, const altStr & sValue);

  ///
  /// \brief  Add Column
  ///
  /// \param  sColumnName [I ] Column Name
  /// \param  pValue      [I ] Column Value
  /// \param  nValueSize  [I ] Column Value Size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_NOMEM     out of memory
  ///
  LIBALT_API alt_t AddStr(const altStr & sColumnName, altChar * pValue, const altUInt nValueSize);

  ///
  /// \brief  Add Column
  ///
  /// \param  sColumnName [I ] Column Name
  /// \param  pValue      [I ] Column Value
  /// \param  nValueSize  [I ] Column Value Size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_NOMEM     out of memory
  ///
  LIBALT_API alt_t Add(const altStr & sColumnName, altChar * pValue, const altUInt nValueSize);

  ///
  /// \brief  Get Size
  ///
  /// \return Row Count
  ///
  LIBALT_API altUInt Size() const;

  ///
  /// \brief  [] operator
  ///
  /// \param  nIndex [I ] index
  ///
  /// \return Column Value
  ///
  LIBALT_API altChar * operator [](const altUInt nIndex) const ALT_THROWS (alt_t);

  ///
  /// \brief  [] operator
  ///
  /// \param  sColumnName [I ] Column Name
  ///
  /// \return Column Value
  ///
  LIBALT_API altChar * operator [](const altStr & sColumnName) const;

  ///
  /// \brief  Get data size
  ///
  /// \param  sColumnName [I ] Column Name
  ///
  /// \return Data size
  ///
  LIBALT_API altUInt GetDataSize(const altStr & sColumnName) const;

  ///
  /// \brief  Get int
  ///
  /// \param  nIndex [I ] index
  /// 
  /// \return Column Value
  ///
  LIBALT_API altInt GetInt(const altUInt nIndex) const;

  ///
  /// \brief  Get int
  ///
  /// \param  sColumnName [I ] Column Name
  /// 
  /// \return Column Value
  ///
  LIBALT_API altInt GetInt(const altStr & sColumnName) const;

  ///
  /// \brief  Get altUInt
  ///
  /// \param  nIndex [I ] index
  /// 
  /// \return Column Value
  ///
  LIBALT_API altUInt GetUInt(const altUInt nIndex) const;

  ///
  /// \brief  Get altUInt
  ///
  /// \param  sColumnName [I ] Column Name
  /// 
  /// \return Column Value
  ///
  LIBALT_API altUInt GetUInt(const altStr & sColumnName) const;

private:
  altRowContainer       m_oDataList;    ///< Result Data List
  mutable altRowMap     m_oDataMap;     ///< Result Data Map
  mutable altRowSizeMap m_oDataSizeMap; ///< Result Data Size Map
};

#endif //ALTDBROW_H

