/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altPostgresDBConnection.cpp 1364 2008-04-22 06:28:33Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altPostgresDBConnection.cpp
 * \brief   PostgreSQL DB Connection Class
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altPostgresDBConnection.h"
#include "altBase/altMem.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altPostgresDBConnection::altPostgresDBConnection() :
m_pPGConn (NULL)
{
}

///
/// \brief  Destructor
///
LIBALT_API altPostgresDBConnection::~altPostgresDBConnection()
{
}

///
/// \brief  Connect
///
/// \param  sHost     [I ] Host Name
/// \param  nPort     [I ] Port Number
/// \param  sDB       [I ] DB Name
/// \param  sUser     [I ] User ID
/// \param  sPass     [I ] Password
/// \param  sCharset  [I ] Charcter Set
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altPostgresDBConnection::Connect(const altStr & sHost, const altUInt nPort, const altStr & sDB, const altStr & sUser, const altStr & sPass, const altStr & sCharset, const altBool bAutoCommit)
{
  altStr  sConnInfo;

  m_pPGConn = PQconnectdb (sConnInfo.Format ("host=%s port=%u dbname=%s user=%s password=%s", sHost.GetCStr(), nPort, sDB.GetCStr(), sUser.GetCStr(), sPass.GetCStr()));
  if (m_pPGConn == NULL) {
    ALT_RET (ALT_E_ERROR);
  }

  if (PQstatus (m_pPGConn) != CONNECTION_OK) {
    ALT_RET_P (ALT_E_ERROR, PQerrorMessage (m_pPGConn));
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Disconnect
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altPostgresDBConnection::Disconnect()
{
  if (m_pPGConn != NULL) {
    PQfinish (m_pPGConn);
    m_pPGConn = NULL;
  }
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Execute SQL
///
/// \param  oSQL    [I ] SQL
/// \param  oResult [ O] Result Set
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_SQL     SQL Error
///
LIBALT_API alt_t altPostgresDBConnection::ExecuteSQL(const altSQL & oSQL, altDBResultSet & oResult)
{
  alt_t status;

  status = ExecuteSQL (oSQL.GetSQLA(), oResult);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Execute SQL
///
/// \param  oSQL          [I ] SQL
/// \param  pAffectedRow  [ O] Affected Row
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_SQL     SQL Error
///
LIBALT_API alt_t altPostgresDBConnection::ExecuteSQL(const altSQL & oSQL, altULongLong * pAffectedRow)
{
  alt_t           status;
  altDBResultSet  oResult;

  status = ExecuteSQL (oSQL, oResult);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Prepared Statement
///
/// \param  oSQL        [I ] SQL
/// \param  pStatement  [ O] Prepared Statement
///
/// \return ALT_S_SUCCESS Success
/// \return ALT_E_SQL     SQL Error
///
LIBALT_API alt_t altPostgresDBConnection::GetPreparedStatement(const altSQL & oSQL, altPreparedStatement * & pStatement)
{
  altInt  nParams = 0;
  altStr  sSQL = oSQL.GetSQLA();

  nParams = sSQL.FindCharCount ("?");

  for (altInt i = 1; i <= nParams; i++) {
    altStr  sBuf;
    sSQL.Replace ("?", sBuf.Format ("$%u", i));
  }

  PGresult *  pResult = PQprepare (m_pPGConn, oSQL.GetSQLName().GetCStr(), sSQL.GetCStr(), nParams, NULL);
  if (PQresultStatus (pResult) != PGRES_COMMAND_OK) {
    PQclear (pResult);
    ALT_RET_P (ALT_E_SQL, PQerrorMessage (m_pPGConn));
  }
  PQclear (pResult);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Execute SQL
///
/// \param  oStmt       [IO] Prepared Statement
/// \param  oResultSet  [ O] ResultSet
///
/// \return ALT_S_SUCCESS Success
/// \return ALT_E_SQL     SQL Error
///
LIBALT_API alt_t altPostgresDBConnection::ExecuteSQL(altPreparedStatement & oStmt, altDBResultSet & oResultSet)
{

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Execute SQL
///
/// \param  oStmt         [IO] Prepared Statement
/// \param  pAffectedRow  [ O] ResultSet
///
/// \return ALT_S_SUCCESS Success
/// \return ALT_E_SQL     SQL Error
///
LIBALT_API alt_t altPostgresDBConnection::ExecuteSQL(altPreparedStatement & oStmt, altULongLong * pAffectedRow)
{
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Begin
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altPostgresDBConnection::Begin()
{
  alt_t status;
  status = ExecuteSQL ("BEGIN");
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Commit
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altPostgresDBConnection::Commit()
{
  alt_t status;
  status = ExecuteSQL ("COMMIT");
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Rollback
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altPostgresDBConnection::Rollback()
{
  alt_t status;
  status = ExecuteSQL ("ROLLBACK");
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Execute SQL
///
/// \param  oSQL    [I ] SQL
/// \param  oResult [ O] Result Set
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_SQL     SQL Error
///
LIBALT_API alt_t altPostgresDBConnection::ExecuteSQL(const altStr & sSQL, altDBResultSet & oResult)
{
  alt_t   status;
  altStr  sExecSQL;

  PGresult * pResult = PQexec (m_pPGConn, sExecSQL.Format ("DECLARE myportal CURSOR FOR %s", sSQL.GetCStr()));
  if (pResult == NULL) {
    altStr  sBuf;
    ALT_RET_P (ALT_E_SQL, PQerrorMessage (m_pPGConn));
  }
  
  if (PQresultStatus (pResult) != PGRES_COMMAND_OK) {
    altStr  sBuf;
    PQclear (pResult);
    ALT_RET_P (ALT_E_SQL, PQerrorMessage (m_pPGConn));
  }
  PQclear (pResult);

  pResult = PQexec (m_pPGConn, "FETCH ALL in myportal");
  if (PQresultStatus (pResult) != PGRES_COMMAND_OK) {
    altStr  sBuf;
    PQclear (pResult);
    ALT_RET_P (ALT_E_SQL, PQerrorMessage (m_pPGConn));
  }

  altInt  nFields;
  nFields = PQnfields (pResult);
  for (altInt i = 0; i < PQntuples (pResult); i++) {
    altDBRow *  pRow = ALT_NEW altDBRow();
    for (altInt j = 0; j < nFields; j++) {
      altStr  sColName = PQfname (pResult, j);
      status = pRow->Add (sColName, PQgetvalue (pResult, i, j));
      ALT_ERR_RET (status);
    }
    status = oResult.Add (pRow);
    ALT_ERR_RET (status);
  }
  PQclear (pResult);

  pResult = PQexec (m_pPGConn, "CLOSE myportal");
  PQclear (pResult);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Execute SQL
///
/// \param  oSQL    [I ] SQL
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_SQL     SQL Error
///
LIBALT_API alt_t altPostgresDBConnection::ExecuteSQL(const altStr & sSQL)
{
  PGresult * pResult = NULL;
  pResult = PQexec (m_pPGConn, sSQL.GetCStr());
  if (PQresultStatus (pResult) != PGRES_COMMAND_OK) {
    PQclear (pResult);
    ALT_RET_P (ALT_E_SQL, PQerrorMessage (m_pPGConn));
  }
  PQclear (pResult);

  ALT_RET (ALT_S_SUCCESS);
}
