#ifndef ALTPOSTGRESDBCONNECTION_H
#define ALTPOSTGRESDBCONNECTION_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altPostgresDBConnection.h 1363 2008-04-22 06:04:15Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altPostgresDBConnection.h
 * \brief   PostgreSQL Connection Class
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBConnection.h>
#include <altDB/postgres/libpq-fe.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  PostgreSQL DB Connection
///
class altPostgresDBConnection : public altDBConnection
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altPostgresDBConnection();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altPostgresDBConnection();

  ///
  /// \brief  Connect
  ///
  /// \param  sHost     [I ] Host Name
  /// \param  nPort     [I ] Port Number
  /// \param  sDB       [I ] DB Name
  /// \param  sUser     [I ] User ID
  /// \param  sPass     [I ] Password
  /// \param  sCharset  [I ] Charcter Set
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Connect(const altStr & sHost, const altUInt nPort, const altStr & sDB, const altStr & sUser, const altStr & sPass, const altStr & sCharset, const altBool bAutoCommit = false);

  ///
  /// \brief  Disconnect
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Disconnect();

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oSQL    [I ] SQL
  /// \param  oResult [ O] Result Set
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altSQL & oSQL, altDBResultSet & oResult);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oSQL          [I ] SQL
  /// \param  pAffectedRow  [ O] Affected Row
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altSQL & oSQL, altULongLong * pAffectedRow = NULL);

  ///
  /// \brief  Get Prepared Statement
  ///
  /// \param  oSQL        [I ] SQL
  /// \param  pStatement  [ O] Prepared Statement
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  LIBALT_API alt_t GetPreparedStatement(const altSQL & oSQL, altPreparedStatement * & pStatement);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oStmt       [IO] Prepared Statement
  /// \param  oResultSet  [ O] ResultSet
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  LIBALT_API alt_t ExecuteSQL(altPreparedStatement & oStmt, altDBResultSet & oResultSet);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oStmt         [IO] Prepared Statement
  /// \param  pAffectedRow  [ O] ResultSet
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  LIBALT_API alt_t ExecuteSQL(altPreparedStatement & oStmt, altULongLong * pAffectedRow = NULL);

  ///
  /// \brief  Begin
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Begin();

  ///
  /// \brief  Commit
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
	LIBALT_API alt_t Commit();

  ///
  /// \brief  Rollback
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
	LIBALT_API alt_t Rollback();

private:
  ///
  /// \brief  Execute SQL
  ///
  /// \param  oSQL    [I ] SQL
  /// \param  oResult [ O] Result Set
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altStr & sSQL, altDBResultSet & oResult);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oSQL    [I ] SQL
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altStr & sSQL);

  PGconn *    m_pPGConn;  ///< Connection
};

#endif
