#ifndef ALTSQLLOADER_H
#define ALTSQLLOADER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSQLLoader.h 1243 2008-04-07 05:11:33Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSQLLoader.h
 * \brief   SQL Loader Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altSQL.h>
#include <altDB/altDBConnectionPtr.h>
#include <altDB/altDBConnection.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get Instance
///
/// \return altSQLLoader Instance
///
#define aiSQLLoader altSQLLoader::GetInstance()

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::map<altStr, altChar *>   altSQLContainer;
typedef std::map<altStr, altWChar *>  altWSQLContainer;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  SQL Loader
///
class altSQLLoader : public altSingleton<altSQLLoader>
{
friend class altSingleton<altSQLLoader>;
protected:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSQLLoader();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSQLLoader();

public:
  ///
  /// \brief  Set Directory
  ///
  /// \param  sDir  [I ] Directory Path
  ///
  /// \return ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetDir(const altStr & sDir);

  ///
  /// \brief  Set Unicode mode
  ///
  /// \param  bUnicode  [I ] true...unicode false...not unicode
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetUnicode(const altBool bUnicode);

  ///
  /// \brief  Get SQL
  ///
  /// \param  sFilePath   [I ] File Path
  /// \param  oSQL        [ O] SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQL(const altStr & sFilePath, altSQL & oSQL);

  ///
  /// \brief  Get SQL
  ///
  /// \param  sFilePath   [I ] File Path
  /// \param  oSQL        [ O] SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQLA(const altStr & sFilePath, altSQL & oSQL);

  ///
  /// \brief  Get SQL
  ///
  /// \param  sFilePath   [I ] File Path
  /// \param  oSQL        [ O] SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQLW(const altStr & sFilePath, altSQL & oSQL);

  ///
  /// \brief  Get Prepared Statement SQL
  ///
  /// \param  sFilePath     [I ] File Path
  /// \param  oDBConnection [I ] DB Connection
  /// \param  pStmt         [ O] Prepared Statement SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQL(const altStr & sFilePath, altDBConnection & oDBConnection, altPreparedStatement * & pStmt);

  ///
  /// \brief  Get Prepared Statement SQL
  ///
  /// \param  sFilePath     [I ] File Path
  /// \param  oDBConnection [I ] DB Connection
  /// \param  pStmt         [ O] Prepared Statement SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQLA(const altStr & sFilePath, altDBConnection & oDBConnection, altPreparedStatement * & pStmt);

  ///
  /// \brief  Get Prepared Statement SQL
  ///
  /// \param  sFilePath     [I ] File Path
  /// \param  oDBConnection [I ] DB Connection
  /// \param  pStmt         [ O] Prepared Statement SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQLW(const altStr & sFilePath, altDBConnection & oDBConnection, altPreparedStatement * & pStmt);

  ///
  /// \brief  Get Prepared Statement SQL
  ///
  /// \param  sFilePath     [I ] File Path
  /// \param  oDBConnection [I ] DB Connection
  /// \param  pStmt         [ O] Prepared Statement SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQL(const altStr & sFilePath, altDBConnectionPtr & pDBConnection, altPreparedStatement * & pStmt);

  ///
  /// \brief  Get Prepared Statement SQL
  ///
  /// \param  sFilePath     [I ] File Path
  /// \param  oDBConnection [I ] DB Connection
  /// \param  pStmt         [ O] Prepared Statement SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQLA(const altStr & sFilePath, altDBConnectionPtr & pDBConnection, altPreparedStatement * & pStmt);

  ///
  /// \brief  Get Prepared Statement SQL
  ///
  /// \param  sFilePath     [I ] File Path
  /// \param  oDBConnection [I ] DB Connection
  /// \param  pStmt         [ O] Prepared Statement SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQLW(const altStr & sFilePath, altDBConnectionPtr & oDBConnection, altPreparedStatement * & pStmt);

  ///
  /// \brief  Unicode or not
  ///
  /// \return true  Unicode
  /// \return false Not Unicode
  ///
  LIBALT_API altBool Unicode();

private:
  altSQLContainer   m_oSQLContainer;  ///< SQL Container
  altWSQLContainer  m_oWSQLContainer; ///< SQL Container
  altStr            m_sBaseDir;       ///< SQL Base Directory
  altBool           m_bUnicode;       ///< Unicode mode
};
#endif  //ALTSQLLOADER_H
