#ifndef ALTSQLSERVERDBCONNECTION_H
#define ALTSQLSERVERDBCONNECTION_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id$

  Copyright (C) 2009 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSQLServerDBConnection.h
 * \brief   SQL SERVER Connection Class
 * \date    2009
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBConnection.h>

// ODBC
#include <windows.h>
#include <sql.h>
#include <sqlext.h>
#pragma comment (lib, "odbc32.lib")

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  SQL Server DB Connection
///
class altSQLServerDBConnection : public altDBConnection
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSQLServerDBConnection();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altSQLServerDBConnection();

  ///
  /// \brief  Connect
  ///
  /// \param  sHost     [I ] Host Name
  /// \param  nPort     [I ] Port Number
  /// \param  sDB       [I ] DB Name
  /// \param  sUser     [I ] User ID
  /// \param  sPass     [I ] Password
  /// \param  sCharset  [I ] Charcter Set
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Connect(const altStr & sHost, const altUInt nPort, const altStr & sDB, const altStr & sUser, const altStr & sPass, const altStr & sCharset, const altBool bAutoCommit = false);

  ///
  /// \brief  Disconnect
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Disconnect();

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oSQL    [I ] SQL
  /// \param  oResult [ O] Result Set
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altSQL & oSQL, altDBResultSet & oResult);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oSQL          [I ] SQL
  /// \param  pAffectedRow  [ O] Affected Row
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altSQL & oSQL, altULongLong * pAffectedRow = NULL);

  ///
  /// \brief  Get Prepared Statement
  ///
  /// \param  oSQL        [I ] SQL
  /// \param  pStatement  [ O] Prepared Statement
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  LIBALT_API alt_t GetPreparedStatement(const altSQL & oSQL, altPreparedStatement * & pStatement);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oStmt       [IO] Prepared Statement
  /// \param  oResultSet  [ O] ResultSet
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  LIBALT_API alt_t ExecuteSQL(altPreparedStatement & oStmt, altDBResultSet & oResultSet);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  oStmt         [IO] Prepared Statement
  /// \param  pAffectedRow  [ O] ResultSet
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  LIBALT_API alt_t ExecuteSQL(altPreparedStatement & oStmt, altULongLong * pAffectedRow = NULL);

  ///
  /// \brief  Begin
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Begin();

  ///
  /// \brief  Commit
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
	LIBALT_API alt_t Commit();

  ///
  /// \brief  Rollback
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
	LIBALT_API alt_t Rollback();

private:
  ///
  /// \brief  Execute SQL
  ///
  /// \param  sSQL    [I ] SQL
  /// \param  oResult [ O] Result Set
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altStr & sSQL, altDBResultSet & oResult);

  ///
  /// \brief  Execute SQL
  ///
  /// \param  sSQL          [I ] SQL
  /// \param  pAffectedRow  [ O] Affected Row
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
	LIBALT_API alt_t ExecuteSQL(const altStr & sSQL, altULongLong * pAffectedRow = NULL);

  ///
  /// \brief  Write Explain Log
  ///
  /// \param  oStmt [I ] SQL
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_SQL     SQL Error
  ///
  LIBALT_API alt_t WriteExplainLog(const altPreparedStatement & oStmt);

  ///
  /// \brief  Write Explain Log
  ///
  /// \param  oSQL        [I ] SQL
  /// \param  oResultSet  [I ] ResultSet
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t WriteExplainLog(const altSQL & oSQL, const altDBResultSet oResultSet);


  HENV    henv;
  HDBC    hdbc;
  HSTMT   hstmt;
};


#endif

