#ifndef ALTSQLSERVERPREPAREDSTATEMENT_H
#define ALTSQLSERVERPREPAREDSTATEMENT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id$

  Copyright (C) 2009 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altMySQLPreparedStatement.h
 * \brief   MySQL Prepared Statement Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altPreparedStatement.h>

// ODBC
#include <windows.h>
#include <sql.h>
#include <sqlext.h>
#pragma comment (lib, "odbc32.lib")

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  MySQL Prepared Statement
///
class altSQLServerPreparedStatement : public altPreparedStatement
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  oSQL  [I ] SQL
  ///
  LIBALT_API altSQLServerPreparedStatement(const HDBC hdbc, const altSQL & oSQL);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSQLServerPreparedStatement();

  ///
  /// \brief  Prepare
  ///
  /// \param  oMySQL  [I ] MySQL Object
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_SQL       SQL Error
  ///
  LIBALT_API alt_t Prepare();

  ///
  /// \brief  Execute
  ///
  /// \param  oResultSet  [ O] Result Set
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_SQL       SQL Error
  ///
  LIBALT_API alt_t ExcecuteSQL(altDBResultSet & oResultSet);

  ///
  /// \brief  Execute
  ///
  /// \param  pAffectedRow  [ O] Affected Count
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_SQL       SQL Error
  ///
  LIBALT_API alt_t ExcecuteSQL(altULongLong * pAffectedRow);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altChar nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altByte nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altShort nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altUShort nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altInt nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altUInt nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altLong nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altULong nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altLongLong nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altULongLong nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altFloat nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altDouble nVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  sVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altStr & sVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  sVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altWStr & sVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Add Value
  ///
  /// \param  oVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altDateTime & oVal, const altBool bIsNULL = false, const altInt nColSize = 0);

  ///
  /// \brief  Clear Query Parameter
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Clear();

  ///
  /// \brief  Get SQL String
  ///
  /// \return SQL String
  ///
  LIBALT_API altStr toString() const;

private:
  ///
  /// \brief	Extend Query Buffer
  ///
  /// \return ALT_S_SUCCESS	Success
  /// \return ALT_E_NOMEM		Out of Memory
  ///
  alt_t ExntendQueryBuffer();

  ///
  /// \brief	Bind Query Buffer
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  alt_t BindParam();

  altSQL      m_oSQL;
  SQLHSTMT    m_hstmt;
  altInt      m_nParamCount;
};

#endif

