#ifndef ALTTEXTBOXLISTENER_H
#define ALTTEXTBOXLISTENER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTextBoxListener.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altTextBoxListener.h
 * \brief   Text Box Listener
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altBase/altWStr.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Text Box Listener
///
class altTextBoxListener
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altTextBoxListener();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTextBoxListener();

  ///
  /// \brief  On input call back
  ///
  /// \param  sMessage  [I ] Message
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t OnInput(const altWStr & sMessage) = 0;
};

#endif
#endif
