#ifndef ALTDX_H
#define ALTDX_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDX.h 1428 2009-09-09 02:09:06Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDX.h
 * \brief   DirectX
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN

#include <altDX/altKeyEventListener.h>
#include <altDX/altRootComponent.h>
#include <altBase/altWStr.h>
#include <altBase/altSingleton.h>
#include <altBase/altStatus.h>
#include <altBase/altLog.h>

#include <map>
#include <vector>

#include <d3dx9.h>
#include <dxerr9.h>
#include <d3dx9math.h>

#pragma comment(lib, "d3d9.lib")
#pragma comment(lib, "d3dx9.lib")
#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "winmm.lib")

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get Instance
///
#define aiDX altDX::GetInstance()

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<altKeyEventListener *>  altKeyEventListenerConatiner;

enum altAlphaBlendTypes {
  ALT_ALPHA_BLEND_0 = 0,  ///< `
  ALT_ALPHA_BLEND_1,      ///< Z
  ALT_ALPHA_BLEND_2,      ///< Z
  ALT_ALPHA_BLEND_3,      ///< Z
  ALT_ALPHA_BLEND_4,      ///< Ă
  ALT_ALPHA_BLEND_5,      ///< lK|W]
  ALT_ALPHA_BLEND_6,      ///< s
};

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DirectX
///
class altDX : public altSingleton<altDX>
{
friend class altSingleton<altDX>;
private:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDX();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altDX();

public:
  ///
  /// \brief  Regist class
  ///
  /// \param  hInst       [I ] Instance Handle
  /// \param  sTitle      [I ] Title Name
  /// \param  lpWndProc   [I ] Pointer to the window procedure
  /// 
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t RegisterClass(HINSTANCE hInst, const altWStr & sClassName, WNDPROC lpWndProc = NULL);

  ///
  /// \brief  Create Main Window
  ///
  /// \param  hInst       [I ] Instance Handle
  /// \param  sTitle      [I ] Title Name
  /// \param  nWidth      [I ] Window Width
  /// \param  nHeight     [I ] Widnow Heignt
  /// \param  bFullScreen [I ] FullScreen or not
  /// \param  nCmdshow    [I ] Command show
  /// \param  dwStyle     [I ] Window Style
  /// 
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t CreateMainWindow(HINSTANCE hInst, const altWStr & sTitle, const altInt nWidth, const altInt nHeight, const altBool bFullScreen, const altInt nCmdshow, const DWORD dwStyle);

  ///
  /// \brief  Direct 3D create
  ///
  /// \param  nWidth      [I ] Window Width
  /// \param  nHeight     [I ] Widnow Heignt
  /// \param  bFullScreen [I ] FullScreen or not
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Direct3DCreate(const altInt nWidth, const altInt nHeight, const altBool bFullScreen);

  ///
  /// \brief  Create Main Window
  ///
  /// \param  hInst       [I ] Instance Handle
  /// \param  sTitle      [I ] Title Name
  /// \param  nWidth      [I ] Window Width
  /// \param  nHeight     [I ] Widnow Heignt
  /// \param  bFullScreen [I ] FullScreen or not
  /// \param  nCmdshow    [I ] Command show
  /// \param  dwStyle     [I ] Window style
  /// \param  lpWndProc   [I ] Pointer to the window procedure
  /// 
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Create(HINSTANCE hInst, const altWStr & sTitle, const altInt nWidth, const altInt nHeight, const altBool bFullScreen, const altInt nCmdshow, const DWORD dwStyle = WS_OVERLAPPEDWINDOW, WNDPROC lpWndProc = NULL);

  ///
  /// \brief  Run Application
  /// 
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Run();

  ///
  /// \brief  Add Component
  ///
  /// \param  pComponent  [I ] Pointer of Component
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Add(altComponent * pComponent);

  ///
  /// \brief  Set max frame count in 1 second
  ///
  /// \param  nMaxFrameCount  [I ] Max frame count
  ///
  /// \return ALT_S_SUCCESS
  ///
  LIBALT_API alt_t SetMaxFrameCount(const altUInt nMaxFrameCount);

  ///
  /// \brief  Get D3D Device
  ///
  /// \return D3D Device
  ///
  LIBALT_API LPDIRECT3DDEVICE9 GetDevice();

  ///
  /// \brief  Get Sprite
  ///
  /// \return Sprite
  ///
  LIBALT_API LPD3DXSPRITE GetSprite();

  ///
  /// \brief  Get Window Handle
  ///
  /// \return Window Handle
  ///
  LIBALT_API HWND GetHWnd();

  ///
  /// \brief  Set focus component
  ///
  /// \param  pComponent  [I ] Component
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetFocus(altComponent * pComponent);

  ///
  /// \brief  Get focus component
  ///
  /// \return Focus component
  ///
  LIBALT_API altComponent * GetFocus() const;

  ///
  /// \brief  Add key event listener
  ///
  /// \param  pKeyEventListener [I ] Key event listener
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_INVAL   invalid paramter
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t AddKeyEventListener(altKeyEventListener * pKeyEventListener);

  ///
  /// \brief  Remove key event listener
  ///
  /// \param  pKeyEventListener [I ] Key event listener
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_INVAL   invalid paramter
  ///
  LIBALT_API alt_t RemoveKeyEventListener(altKeyEventListener * pKeyEventListener);

  ///
  /// \brief  Clear device
  ///
  /// \param  dwColor [I ] Color
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t DeviceClear(D3DCOLOR dwColor);

  ///
  /// \brief  Set alpha blend type
  ///
  /// \param  nType [I ] alpha blend type
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetAlphaBlend(const altAlphaBlendTypes nType);

  ///
  /// \brief  Set alpha blend enable
  ///
  /// \param  bEnable [I ] true or false
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetAlphaBlendEnable(const altBool bEnable);

  ///
  /// \brief  Window Function
  ///
  /// \param  hwnd    [I ] Window Handle
  /// \param  msg     [I ] message
  /// \param  wParam  [I ] parameter
  /// \param  lParam  [I ] parameter
  ///
  LIBALT_API static LRESULT ALT_APIENTRY WndFunc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

  ///
  /// \brief  Get altDX Instance
  ///
  /// \return altDX Instance
  ///
  LIBALT_API static altDX & GetInstance();

  ///
  /// \brief  Delete Instance
  ///
  LIBALT_API static void DeleteInstance();

protected:
  ///
  /// \brief Initialize Main Window
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t InitMainWindow();

  ///
  /// \brief  Application Loop
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t AppLoop();

  ///
  /// \brief  Render
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t Render();

  ///
  /// \brief  Get root component
  ///
  /// \return Root component
  ///
  LIBALT_API altRootComponent & GetRootComponent();

  ///
  /// \brief  Release Memory
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t Cleanup();

private:
  LPDIRECT3D9           m_lpD3D;                    ///< Direct3D interface
  LPDIRECT3DDEVICE9     m_lpD3DDevice;              ///< Direct3DDevice interface
  D3DPRESENT_PARAMETERS m_d3dpp;                    ///< Direct3D Parameters
  altBool               m_bAppLoop;                 ///< Application Loop
  altWStr               m_sTitle;                   ///< Application Title
  WNDCLASSEX            m_oWC;                      ///< Window Class
  HWND                  m_oHwnd;                    ///< Window Handle
  altUInt               m_nMaxFrameCount;           ///< Max frame count in 1 second
  LPD3DXSPRITE          m_pSprite;                  ///< Sprite
  altRootComponent      m_oRootComponent;           ///< Root component
  altComponent *        m_pFocus;                   ///< Focus component
};
#endif  // ALT_WIN
#endif  // ALTDX_H
