/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id$

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDXFont.cpp
 * \brief   DirectX 2D Font
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDXFont.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDXFont::altDXFont() :
m_pFont (NULL),
m_sText(),
m_oRect(),
m_dwFormat(),
m_dwColor(),
m_RetH (0)
{
}

///
/// \brief  Destructor
///
LIBALT_API altDXFont::~altDXFont()
{
  if (m_pFont != NULL) {
    m_pFont->Release();
    m_pFont = NULL;
  }
}

///
/// \brief  Create
///
/// \param  h         [I ] Font Height
/// \param  w         [I ] Font Width
/// \param  nWeight   [I ] Font weight
/// \param  bItalic   [I ] Italic or not
/// \param  nCharSet  [I ] Charcter set
/// \param  sFaceName [I ] Font face name
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altDXFont::Create(const altInt h, const altInt w, const altUInt nWeight, const altBool bItalic, const BYTE nCharSet, const altWStr & sFaceName)
{
  HRESULT hr;
  hr = D3DXCreateFont (aiDX.GetDevice(), h, w, nWeight, 1, bItalic, nCharSet, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, (LPCWSTR)sFaceName.GetCStr(), & m_pFont);
  if (FAILED (hr)) {
    ALT_RET (ALT_E_ERROR);
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Set Text
///
/// \param  sText     [I ] Text
/// \param  x         [I ] X
/// \param  y         [I ] Y
/// \param  w         [I ] W
/// \param  h         [I ] H
/// \param  dwFormat  [I ] Foramt
/// \param  dwColor   [I ] Color
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altDXFont::SetText(const altWStr & sText, const altInt x, const altInt y, const altInt w, const altInt h, const DWORD dwFormat, const DWORD dwColor)
{
  m_sText = sText;
  m_oRect.left = x;
  m_oRect.right = x + w;
  m_oRect.top = y;
  m_oRect.bottom = y + h;
  m_dwFormat = dwFormat;
  m_dwColor = dwColor;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Render
///
/// \param  pd3dDevice  [I ] D3D Device
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_ERROR     error
///
LIBALT_API alt_t altDXFont::Render(IDirect3DDevice9 * pDevice)
{
  if (m_pFont != NULL) {
    aiDX.GetSprite()->Begin (D3DXSPRITE_ALPHABLEND | D3DXSPRITE_DONOTSAVESTATE);
    m_RetH = m_pFont->DrawTextW (aiDX.GetSprite(), (LPCWSTR)m_sText.GetCStr(), -1, & m_oRect, m_dwFormat, m_dwColor);
    aiDX.GetSprite()->End();
  }
  ALT_RET (altComponent::Render(pDevice));
}

///
/// \brief  Get return height
///
/// \return Return height
///
LIBALT_API altInt altDXFont::GetRetH()
{
  return (m_RetH);
}

///
/// \brief  Get text width
///
/// \param  sText [I ] Text
///
/// \return Text width
///
LIBALT_API altLong altDXFont::GetWidth(const altWStr & sText) const
{
  GLYPHMETRICS  oGM;
	TEXTMETRIC    oTM;

#if 0
	HDC hdc = GetDC (aiDX.GetHWnd());
  SelectObject (hdc, m_hFont);
#endif

  HDC hdc = m_pFont->GetDC();

  CONST MAT2 Mat = {{0,1},{0,0},{0,0},{0,1}};

  altLong nWidth = 0;
  for (altUInt i = 0; i <= sText.GetLen(); i++) {
    altUInt nCode = sText[i];
	  GetTextMetrics (hdc, & oTM);
	  DWORD nSize = GetGlyphOutline (hdc, nCode, GGO_BEZIER, & oGM, 0, NULL, & Mat);
    if (nSize == GDI_ERROR) {
      altStr  sBuf;
      ALT_LOG_P (ALT_E_ERROR, sBuf.Format ("%lu", GetLastError()));
      continue;
    }
    nWidth += oGM.gmCellIncX;
  }
  ReleaseDC (NULL, hdc);
  return (nWidth);
}