#ifndef ALTD3DXFONT_H
#define ALTD3DXFONT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id$

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDXFont.h
 * \brief   DirectX 2D Font
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altDX.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DirectX 2D Font
///
class altDXFont : public altComponent
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDXFont();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altDXFont();

  ///
  /// \brief  Create
  ///
  /// \param  h         [I ] Font Height
  /// \param  w         [I ] Font Width
  /// \param  nWeight   [I ] Font weight
  /// \param  bItalic   [I ] Italic or not
  /// \param  nCharSet  [I ] Charcter set
  /// \param  sFaceName [I ] Font face name
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Create(const altInt h, const altInt w, const altUInt nWeight = FW_NORMAL, const altBool bItalic = false, const BYTE nCharSet = SHIFTJIS_CHARSET, const altWStr & sFaceName = _T(""));

  ///
  /// \brief  Set Text
  ///
  /// \param  sText     [I ] Text
  /// \param  x         [I ] X
  /// \param  y         [I ] Y
  /// \param  w         [I ] W
  /// \param  h         [I ] H
  /// \param  dwFormat  [I ] Foramt
  /// \param  dwColor   [I ] Color
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t SetText(const altWStr & sText, const altInt x, const altInt y, const altInt w, const altInt h, const DWORD dwFormat = DT_LEFT | DT_NOCLIP, const DWORD dwColor = D3DCOLOR_XRGB (0, 0, 0));

  ///
  /// \brief  Render
  ///
  /// \param  pd3dDevice  [I ] D3D Device
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Render(IDirect3DDevice9 * pDevice);

  ///
  /// \brief  Get return height
  ///
  /// \return Return height
  ///
  LIBALT_API altInt GetRetH();

  ///
  /// \brief  Get text width
  ///
  /// \param  sText [I ] Text
  ///
  /// \return Text width
  ///
  LIBALT_API altLong GetWidth(const altWStr & sText) const;

private:
  LPD3DXFONT  m_pFont;
  altWStr     m_sText;
  RECT        m_oRect;
  DWORD       m_dwFormat;
  DWORD       m_dwColor;
  altInt      m_RetH;
};

#endif
#endif
