#ifndef ALTEVENT_H
#define ALTEVENT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altEvent.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altEvent.h
 * \brief   Event
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altComponent.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Event
///
class altEvent : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altEvent(const altUInt nType, altComponent * pSource);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altEvent();

  ///
  /// \brief  Get event type
  ///
  /// \return Event type
  ///
  LIBALT_API altUInt GetType() const;

  ///
  /// \brief  Get event source
  ///
  /// \return Evnet source
  ///
  LIBALT_API altComponent * GetEventSource() const;

private:
  altUInt         m_nType;
  altComponent *  m_pSource;
};

#endif
#endif