/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altFontManager.cpp 1321 2008-04-15 16:15:58Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altFontManager.cpp
 * \brief   DirectX 2D Font Manager
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altFontManager.h"
#ifdef ALT_WIN

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altFontManager::altFontManager() :
m_oFontMap()
{
  this->CreateFont ("Default", 12);
  this->CreateFont ("Default_BOLD", 12, 0, FW_BOLD);
}

///
/// \brief  Destructor
///
LIBALT_API altFontManager::~altFontManager()
{
  for (altFontMap::iterator i = m_oFontMap.begin(); i != m_oFontMap.end(); i++) {
    delete i->second;
  }
  m_oFontMap.clear();
}

///
/// \brief  Create new font
///
/// \param  h         [I ] Font Height
/// \param  w         [I ] Font Width
/// \param  nWeight   [I ] Font weight
/// \param  bItalic   [I ] Italic or not
/// \param  nCharSet  [I ] Charcter set
/// \param  sFaceName [I ] Font face name
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altFontManager::CreateFont(const altStr & sFontName, const altInt h, const altInt w, const altUInt nWeight, const altBool bItalic, const BYTE nCharSet, const altWStr & sFaceName)
{
  try {
    alt_t status;
    altDXFont * pFont = ALT_NEW altDXFont();
    if (pFont == NULL) {
      ALT_RET (ALT_E_NOMEM);
    }
    status = pFont->Create (h, w, nWeight, bItalic, nCharSet, sFaceName);
    ALT_ERR_RET (status);
    m_oFontMap[sFontName] = pFont;
  }
  catch (alt_t e) {
    ALT_RET (e);
  }
  catch (std::exception & e) {
    ALT_LOG_P (ALT_E_ERROR, e.what());
    ALT_RET (ALT_E_ERROR);
  }
  catch (...) {
    ALT_RET (ALT_E_ERROR);
  }
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get font
///
/// \param  sFontName [I ] Font name
///
/// \return Pointer of font
///
LIBALT_API altDXFont * altFontManager::GetFont(const altStr & sFontName)
{
  return (m_oFontMap[sFontName]);
}

///
/// \brief  Get altFontManager Instance
///
/// \return altDX Instance
///
LIBALT_API altFontManager & altFontManager::GetInstance()
{
  return (altSingleton<altFontManager>::GetInstance());
}

///
/// \brief  Delete Instance
///
LIBALT_API void altFontManager::DeleteInstance()
{
  altSingleton<altFontManager>::DeleteInstance();
}

#endif
