#ifndef ALTFONTMANAGER_H
#define ALTFONTMANAGER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altFontManager.h 1321 2008-04-15 16:15:58Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altFontManager.h
 * \brief   DirectX 2D Font Manager
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altDXFont.h>
#include <altBase/altStr.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define aiFontManager altFontManager::GetInstance()   ///< Get font manager instance

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::map<altStr, altDXFont *> altFontMap;   ///< Font Container

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DirectX 2D Font Manager
///
class altFontManager : public altSingleton<altFontManager>
{
friend class altSingleton<altFontManager>;
private:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altFontManager();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altFontManager();

public:
  ///
  /// \brief  Create new font
  ///
  /// \param  h         [I ] Font Height
  /// \param  w         [I ] Font Width
  /// \param  nWeight   [I ] Font weight
  /// \param  bItalic   [I ] Italic or not
  /// \param  nCharSet  [I ] Charcter set
  /// \param  sFaceName [I ] Font face name
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t CreateFont(const altStr & sFontName, const altInt h, const altInt w = 0, const altUInt nWeight = FW_NORMAL, const altBool bItalic = false, const BYTE nCharSet = SHIFTJIS_CHARSET, const altWStr & sFaceName = (wchar_t *)_T("lro SVbN"));

  ///
  /// \brief  Get font
  ///
  /// \param  sFontName [I ] Font name
  ///
  /// \return Pointer of font
  ///
  LIBALT_API altDXFont * GetFont(const altStr & sFontName);

  ///
  /// \brief  Get altFontManager Instance
  ///
  /// \return altDX Instance
  ///
  LIBALT_API static altFontManager & GetInstance();

  ///
  /// \brief  Delete Instance
  ///
  LIBALT_API static void DeleteInstance();

private:
  altFontMap  m_oFontMap;
};

#endif
#endif
