#ifndef ALTIMECOMPONENT_H
#define ALTIMECOMPONENT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altIMEComponent.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altIMEComponent.h
 * \brief   IME Control Component
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altBase/altWStr.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  IME Control Component
///
class altIMEComponent : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altIMEComponent();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altIMEComponent();

  ///
  /// \brief  Input IME word
  ///
  /// \param  sData [I ] IME word
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API virtual alt_t InputIMEWord(const altWStr & sData) = 0;

  ///
  /// \brief  Send IME word
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API virtual alt_t SendIMEWord(const altWStr & sData) = 0;
};

#endif
#endif
