#ifndef ALTKEYEVENTLISTENER_H
#define ALTKEYEVENTLISTENER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altKeyEventListener.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altKeyEventListener.h
 * \brief   Key Event Listener
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altEvent.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Key Event Listener
///
class altKeyEventListener : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altKeyEventListener();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altKeyEventListener();

  ///
  /// \brief  Listen key down event
  ///
  /// \param  oEvent  [I ] Event
  /// \param  nKey    [I ] Key
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t OnKeyDown(const altEvent & oEvent, const altUInt nKey) = 0;
};

#endif
#endif