#ifndef ALTXFILE_H
#define ALTXFILE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altXFile.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altXFile.h
 * \brief   DirectX X File
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altLog.h>
#include <altBase/altBase.h>

#ifdef ALT_WIN
#include <altDX/altDX.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
struct XFILE
{
	LPD3DXMESH            lpMesh;
	DWORD                 NumMaterial;
	D3DMATERIAL9 *        Mat;
	LPDIRECT3DTEXTURE9 *  Tex;
};

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
class altXFile : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altXFile();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altXFile();

  ///
  /// \brief  Load X File
  ///
  /// \param  sFileName   [I ] File Name
  /// \param  dwOptions   [I ] Options
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Load(const altStr & sFileName, const DWORD dwOptions = D3DXMESH_MANAGED);

  ///
  /// \brief  Release X File
  ///
  LIBALT_API void Release();
  
  ///
  /// \brief  Draw X File
  ///
  LIBALT_API void Draw();

  ///
  /// \brief  Draw X File Color
  ///
  LIBALT_API void DrawColor(int ColorNo);

private:
  struct XFILE *      m_pXFile;
};

#endif
#endif
