/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altBlowFish.cpp 1398 2008-10-20 17:23:23Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altBlowFish.cpp
 * \brief   BlowFish Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altBlowFish.h"
#include "altBase/altMem.h"
#include "altBase/altStatus.h"
#include <stdlib.h>

/*----------------------------------------------------------------*
 * Static Variable
 *----------------------------------------------------------------*/
static const DWORD ALT_CRYPT_MAGIC = 0x32564523;   ///< Magic Number

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altBlowFish::altBlowFish() :
m_bInitialized (false),
m_oBFKey()
{
}

///
/// \brief  Destructor
///
LIBALT_API altBlowFish::~altBlowFish()
{
}

///
/// \brief  Initialize
///
/// \param  pKey  [I ] Crypt Key
/// \param  nSize [I ] Crypt Key Size
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_ERROR     error
/// \return ALT_E_INVAL     invalid paramter
///
LIBALT_API alt_t altBlowFish::Initialize(const altByte * pKey, altInt nSize)
{
  ALT_P_ASSERT (pKey != NULL);

  BF_set_key (& m_oBFKey, nSize, pKey);
  m_bInitialized = true;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Encrypt
///
/// \param  pData [IO] Data
/// \param  nSize [IO] Data Size
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_NOMEM     out of memory
/// \return ALT_E_ERROR     error
/// \return ALT_E_INVAL     invalid paramter
///
LIBALT_API alt_t altBlowFish::Encode(altCharPtr & pData, altUInt & nSize)
{
  ALT_P_ASSERT (pData != NULL);

  if (! m_bInitialized) {
    ALT_RET_P (ALT_E_ERROR, "Not Initialized");
  }

  alt_t status;

  altUInt   nAddSize = (8 - (nSize % 8)) + 8;
  altUInt   nNewSize = nSize + nAddSize;
  altChar * pEncodeData = NULL;

  if (nNewSize % 2 != 0) {
    nNewSize += 8;
    nAddSize += 8;
  }

  status = ALT_MALLOC (pEncodeData, nNewSize);
  ALT_ERR_RET (status);

  memcpy (pEncodeData, (const altChar *)pData, nSize);
  memcpy (& pEncodeData[nNewSize - 9], & ALT_CRYPT_MAGIC, 4);
  memcpy (& pEncodeData[nNewSize - 5], & nAddSize, 4);

  ALT_E_ASSERT ((nNewSize % BF_BLOCK) == 0);

  altChar * pBuf = (altChar *)pEncodeData;
  for (altUInt i = 0; i < (nNewSize / BF_BLOCK); i++) {
    BF_encrypt ((BF_LONG *)(pBuf + (i * BF_BLOCK)), & m_oBFKey);
  }

  pData = pEncodeData;
  nSize = nNewSize;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Decrypt
///
/// \param  pData [IO] Data
/// \param  nSize [IO] Data Size
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_NOMEM     out of memory
/// \return ALT_E_ERROR     error
/// \return ALT_E_INVAL     invalid paramter
///
LIBALT_API alt_t altBlowFish::Decode(altCharPtr & pData, altUInt & nSize)
{
  ALT_P_ASSERT (pData != NULL);
  ALT_P_ASSERT ((nSize % BF_BLOCK) == 0);

  if (! m_bInitialized) {
    ALT_RET_P (ALT_E_ERROR, "Not Initialized");
  }

  alt_t     status;

  altChar * pBuf = (altChar *)pData;
  for (altUInt i = 0; i < (nSize / BF_BLOCK); i++) {
    BF_decrypt ((BF_LONG *)(pBuf + (i * BF_BLOCK)), & m_oBFKey);
  }

  altUInt nDelSize;
  memcpy (& nDelSize, & pData[nSize - 5], 4);

  DWORD   dwMagic;
  memcpy (& dwMagic, & pData[nSize - 9], 4);

  if (dwMagic != ALT_CRYPT_MAGIC) {
    ALT_RET_P (ALT_E_ERROR, "crypto magic invalid");
  }

  altUInt   nNewSize = nSize - nDelSize;
  altChar * pOutData = NULL;

  status = ALT_MALLOC (pOutData, nNewSize + 1);
  ALT_ERR_RET (status);
  memcpy (pOutData, (const altChar *)pData, nNewSize);

  pData = pOutData;
  nSize = nNewSize;

  ALT_RET (ALT_S_SUCCESS);
}

