#ifndef ALTBZIP2_H
#define ALTBZIP2_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altBzip2.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altBzip2.h
 * \brief   bzip2
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCharPtr.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  bzip2
///
class altBzip2 : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altBzip2();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altBzip2();

  ///
  /// \brief  Compress
  ///
  /// \param  pData   [IO] Data
  /// \param  nLen    [IO] Data Length
  ///
  /// \return ALT_S_SUCCESS         Success
  /// \return ALT_S_OUTBUFFER_FULL  Out buffer is full
  /// \return ALT_E_NOMEM           Out of memory
  /// \return ALT_E_ERROR           Error
  ///
  LIBALT_API alt_t Compress(altCharPtr & pData, altUInt & nLen);

  ///
  /// \brief  Decompress
  ///
  /// \param  pData   [IO] Data
  /// \param  nLen    [IO] Data Length
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t Decompress(altCharPtr & pData, altUInt & nLen);

  ///
  /// \brief  Compress
  ///
  /// \param  pData   [IO] Data
  /// \param  nLen    [IO] Data Length
  ///
  /// \return ALT_S_SUCCESS         Success
  /// \return ALT_S_OUTBUFFER_FULL  Out buffer is full
  /// \return ALT_E_NOMEM           Out of memory
  /// \return ALT_E_ERROR           Error
  ///
  LIBALT_API alt_t Compress(altChar * & pData, altUInt & nLen);

  ///
  /// \brief  Decompress
  ///
  /// \param  pData   [IO] Data
  /// \param  nLen    [IO] Data Length
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t Decompress(altChar * & pData, altUInt & nLen);

private:
  ///
  /// \brief  Compress
  ///
  /// \param  pDst    [ O] Data
  /// \param  nDstLen [ O] Data Length
  /// \param  pSrc    [I ] Data
  /// \param  nSrcLen [I ] Data Length
  ///
  /// \return ALT_S_SUCCESS         Success
  /// \return ALT_S_OUTBUFFER_FULL  Out Buffer Full
  /// \return ALT_E_ERROR           Error
  ///
  LIBALT_API alt_t Compress(altChar * pDst, altUInt & nDstLen, altChar * pSrc, altUInt nSrcLen);

  ///
  /// \brief  Decompress
  ///
  /// \param  pDst    [ O] Data
  /// \param  nDstLen [ O] Data Length
  /// \param  pSrc    [I ] Data
  /// \param  nSrcLen [I ] Data Length
  ///
  /// \return ALT_S_SUCCESS         Success
  /// \return ALT_S_NOCOMPRESS      No Compress
  /// \return ALT_S_OUTBUFFER_FULL  Out Buffer Full
  /// \return ALT_E_ERROR           Error
  ///
  LIBALT_API alt_t Decompress(altChar * pDst, altUInt nDstLen, altChar * pSrc, altUInt nSrcLen);
};

#endif
