/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altClock.cpp 1321 2008-04-15 16:15:58Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altClock.cpp
 * \brief   Clock Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altClock.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altClock::altClock()
{
  m_nStartTime = std::clock();
}

///
/// \brief  Destructor
///
LIBALT_API altClock::~altClock()
{
}

///
/// \brief  Start
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altClock::Start()
{
  m_nStartTime = std::clock();
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Elapsed time
///
/// \return Elapsed time
///
LIBALT_API altDouble altClock::Elapsed()
{
  return (altDouble(std::clock() - m_nStartTime) / CLOCKS_PER_SEC);
}

///
/// \brief  Write
///
/// \param  oDataStream [ O] Data stream
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_NOMEM   out of memory
///
LIBALT_API alt_t altClock::Write(altDataStream & oDataStream) const
{
  alt_t status;
  status = oDataStream.Write (m_nStartTime);
  ALT_ERR_RET (status);
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Read
///
/// \param  oDataStream [I ] Data stream
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_NOMEM   out of memory
///
LIBALT_API alt_t altClock::Read(altDataStream & oDataStream) const
{
  alt_t status;
#ifdef ALT_WIN
  status = oDataStream.Read ((altLong)(m_nStartTime));
#endif
#ifdef ALT_LINUX
  altLong nStartTime = (altLong)m_nStartTime;
  status = oDataStream.Read (nStartTime);
#endif
  ALT_ERR_RET (status);
  ALT_RET (ALT_S_SUCCESS);
}

