#ifndef ALTCLOCK_H
#define ALTCLOCK_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altClock.h 1321 2008-04-15 16:15:58Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altClock.h
 * \brief   clock
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altLog.h>
#include <altBase/altExternalizable.h>
#include <ctime>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  clock
///
class altClock : public altExternalizable
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altClock();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altClock();

  ///
  /// \brief  Start
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Start();

  ///
  /// \brief  Get Elapsed time
  ///
  /// \return Elapsed time
  ///
  LIBALT_API altDouble Elapsed();

  ///
  /// \brief  Write
  ///
  /// \param  oDataStream [ O] Data stream
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t virtual Write(altDataStream & oDataStream) const;

  ///
  /// \brief  Read
  ///
  /// \param  oDataStream [I ] Data stream
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t virtual Read(altDataStream & oDataStream) const;

private:
  std::clock_t m_nStartTime;    ///< Start time
};

#endif
