/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDict.cpp 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDict.cpp
 * \brief   Dictionary Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDict.h"
#include "altFile.h"
#include "altBase/altLog.h"

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get method template
///
/// \param  method  [I ] method name
///
#define ALT_PROPERTY_TO_X(method) \
  altWStr * pValue = m_oDictDataMap[sKey]; \
  if (pValue == NULL) { \
    return (nDefault); \
  } \
  return (pValue->method());

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDict::altDict()
{
}

///
/// \brief  Destructor
///
LIBALT_API altDict::~altDict()
{
}

///
/// \brief  Load Property File
///
/// \param  sFileName [I ] file name
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_ERROR     error
///
LIBALT_API alt_t altDict::Load(const altStr & sFileName)
{
  alt_t     status;
  altFile   oFile;
  altWStr   sBuf;
  altWChar  szBuf[ALT_BUFSIZ];
  altUInt   nLine = 0;

  status = oFile.Open (sFileName, "r");
  ALT_ERR_RET (status);

  while (true) {
    memset (szBuf, 0x00, sizeof (szBuf));
    status = oFile.ReadLine (szBuf, sizeof (szBuf));

    // error caused
    if (ALT_IS_ERR (status)) {
      ALT_LOG (status);
      oFile.Close();
      ALT_RET (status);
    }

    if (nLine == 0) {
      altWChar wUTF16;
      memcpy (& wUTF16, szBuf, sizeof (wUTF16));
      if (wUTF16 == 0xFEFF) {
        memmove (& szBuf[0], & szBuf[1], sizeof (szBuf));
      }
      else {
        ALT_RET_P (ALT_E_ERROR, "Support UTF-16 only");
      }
    }
    nLine++;

    sBuf = szBuf;

    // delete comment
    altInt nCommentIndex = sBuf.Find (L"#");
    if (nCommentIndex >= 0 && sBuf[nCommentIndex - sizeof (altWChar)] != L'\\') {
      sBuf = sBuf.SubStr(0, nCommentIndex - 1);
    }

    altInt nEqualIndex = sBuf.Find (L"=");
    if (nEqualIndex > 0) {
      altWStr  sKey = sBuf.SubStr (0, nEqualIndex);
      altWStr  sValue = sBuf.SubStr (nEqualIndex + 1);
      sKey.Trim();
      sValue.Trim();
      m_oDictDataMap[sKey] = ALT_NEW altWStr (sValue);
    }

    // end of file
    if (status == ALT_S_EOF) {
      status = oFile.Close();
      ALT_LOG (status);
      break;
    }
  }
  oFile.Close();

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Boolean Value
///
/// \param  sKey      [I ] Key Name
/// \param  bDefault  [I ] Default Value
///
/// \return Boolean Value
///
LIBALT_API altBool altDict::GetBool(const altWStr & sKey, const altBool nDefault)
{
  ALT_PROPERTY_TO_X (ToBool);
}

///
/// \brief  Get Short Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Short Value
///
LIBALT_API altShort altDict::GetShort(const altWStr & sKey, const altShort nDefault)
{
  ALT_PROPERTY_TO_X (ToShort);
}

///
/// \brief  Get Unsigned Short Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Unsigned Short Value
///
LIBALT_API altUShort altDict::GetUShort(const altWStr & sKey, const altUShort nDefault)
{
  ALT_PROPERTY_TO_X (ToUShort);
}

///
/// \brief  Get Int Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Int Value
///
LIBALT_API altInt altDict::GetInt(const altWStr & sKey, const altInt nDefault)
{
  ALT_PROPERTY_TO_X (ToInt);
}

///
/// \brief  Get Unsigned Int Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Unsigned Int Value
///
LIBALT_API altUInt altDict::GetUInt(const altWStr & sKey, const altUInt nDefault)
{
  ALT_PROPERTY_TO_X (ToUInt);
}
  
///
/// \brief  Get Long Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Long Value
///
LIBALT_API altLong altDict::GetLong(const altWStr & sKey, const altLong nDefault)
{
  ALT_PROPERTY_TO_X (ToLong);
}

///
/// \brief  Get Unsigned Long Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Unsigned Long Value
///
LIBALT_API altULong altDict::GetULong(const altWStr & sKey, const altULong nDefault)
{
  ALT_PROPERTY_TO_X (ToULong);
}

///
/// \brief  Get Long Long Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Long Long Value
///
LIBALT_API altLongLong altDict::GetLongLong(const altWStr & sKey, const altLongLong nDefault)
{
  ALT_PROPERTY_TO_X (ToLongLong);
}

///
/// \brief  Get Unsigned Long Long Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Unsigned Long Long Value
///
LIBALT_API altULongLong altDict::GetULongLong(const altWStr & sKey, const altULongLong nDefault)
{
  ALT_PROPERTY_TO_X (ToULongLong);
}

///
/// \brief  Get Float Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Float Value
///
LIBALT_API altFloat altDict::GetFloat(const altWStr & sKey, const altFloat nDefault)
{
  ALT_PROPERTY_TO_X (ToFloat);
}

///
/// \brief  Get Double Value
///
/// \param  sKey      [I ] Key Name
/// \param  nDefault  [I ] Default Value
///
/// \return Double Value
///
LIBALT_API altDouble altDict::GetDouble(const altWStr & sKey, const altDouble nDefault)
{
  ALT_PROPERTY_TO_X (ToDouble);
}

///
/// \brief  Get Wide String Value
///
/// \param  sKey      [I ] Key Name
///
/// \return String Value
///
LIBALT_API altWStr altDict::GetWStr(const altWStr & sKey)
{
  altWStr * pValue = m_oDictDataMap[sKey];
  if (pValue == NULL) {
    return (sKey);
  }
  return (* pValue);
}

