#ifndef ALTDICT_H
#define ALTDICT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDict.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDict.h
 * \brief   Dictionary
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBaseLog.h>
#include <altBase/altStr.h>
#include <altBase/altWStr.h>

#include <map>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::map<altWStr, altWStr *>  altDictData;  ///< setting data

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Dictionary
///
class altDict
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDict();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altDict();

  ///
  /// \brief  Load Property File
  ///
  /// \param  sFileName [I ] file name
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Load(const altStr & sFileName);

  ///
  /// \brief  Get Boolean Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  bDefault  [I ] Default Value
  ///
  /// \return Boolean Value
  ///
  LIBALT_API altBool GetBool(const altWStr & sKey, const altBool nDefault = false);

  ///
  /// \brief  Get Short Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Short Value
  ///
  LIBALT_API altShort GetShort(const altWStr & sKey, const altShort nDefault = 0);

  ///
  /// \brief  Get Unsigned Short Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Short Value
  ///
  LIBALT_API altUShort GetUShort(const altWStr & sKey, const altUShort nDefault = 0);

  ///
  /// \brief  Get Int Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Int Value
  ///
  LIBALT_API altInt GetInt(const altWStr & sKey, const altInt nDefault = 0);

  ///
  /// \brief  Get Unsigned Int Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Int Value
  ///
  LIBALT_API altUInt GetUInt(const altWStr & sKey, const altUInt nDefault = 0);

  ///
  /// \brief  Get Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Long Value
  ///
  LIBALT_API altLong GetLong(const altWStr & sKey, const altLong nDefault = 0);

  ///
  /// \brief  Get Unsigned Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Long Value
  ///
  LIBALT_API altULong GetULong(const altWStr & sKey, const altULong nDefault = 0);

  ///
  /// \brief  Get Long Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Long Long Value
  ///
  LIBALT_API altLongLong GetLongLong(const altWStr & sKey, const altLongLong nDefault = 0);

  ///
  /// \brief  Get Unsigned Long Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Long Long Value
  ///
  LIBALT_API altULongLong GetULongLong(const altWStr & sKey, const altULongLong nDefault = 0);

  ///
  /// \brief  Get Float Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Float Value
  ///
  LIBALT_API altFloat GetFloat(const altWStr & sKey, const altFloat nDefault = 0);

  ///
  /// \brief  Get Double Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Double Value
  ///
  LIBALT_API altDouble GetDouble(const altWStr & sKey, const altDouble nDefault = 0);

  ///
  /// \brief  Get Wide String Value
  ///
  /// \param  sKey      [I ] Key Name
  ///
  /// \return String Value
  ///
  LIBALT_API altWStr GetWStr(const altWStr & sKey);

protected:
  altDictData   m_oDictDataMap;   ///< property data map
};

#endif  // ALTPROPERTY_H

