/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDir.cpp 1424 2008-11-17 14:21:35Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDir.cpp
 * \brief   Directory Class
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDir.h"
#include "altBase/altUtil.h"

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDir::altDir()
{
}

///
/// \brief  Destructor
///
LIBALT_API altDir::~altDir()
{
}

///
/// \brief  Get file list
///
/// \param  sSearch     [I ] Search
/// \param  bRecursive  [I ] Recursive or not
///
/// \return File list
///
LIBALT_API altStrList altDir::GetFileList(const altStr & sSearch, const altBool bRecursive, const altStr & sDirPath) const
{
  altStrList      oFileList;
#ifdef ALT_WIN
  static altUInt  nDepth = 0;
  WIN32_FIND_DATAA FindFileData;
  HANDLE hFind = FindFirstFileA (sSearch.GetCStr(), & FindFileData);
  if (hFind == INVALID_HANDLE_VALUE) {
    return (oFileList);
  }
  
  do {
    altStr  sFileName = FindFileData.cFileName;
    if (sFileName != "." && sFileName != "..") {
      if (FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY && bRecursive) {
        altStr  sDirName = sDirPath + "/*.*";
        altStr  sDir = sDirPath;

        if (nDepth > 0) {
          sDirName = sDirPath + "/" + sFileName + "/*.*";
          sDir = sDirPath + "/" + sFileName;
        }
        else {
          sDirName = sDirPath + "/*.*";
          sDir = sDirPath;
        }

        nDepth++;
        altStrList oBuf = GetFileList (sDirName, bRecursive, sDir);
        for (altUInt i = 0; i < oBuf.size(); i++) {
          oFileList.push_back (oBuf[i]);
        }
        nDepth--;
      }
      else {
        altStr  sFilePath = sDirPath + "/" + sFileName;
        oFileList.push_back (sFilePath);
      }
    }
  } while (FindNextFileA (hFind, & FindFileData));
#endif
#ifdef ALT_LINUX
  DIR *           pDir = opendir (sSearch.GetCStr());
  struct dirent * pDent;
  if (pDir == NULL) {
    return (oFileList);
  }
  while ((pDent = readdir (pDir)) != NULL) {
    // directory
    if (pDent->d_type == DT_DIR && bRecursive) {
      altStr  sDirName = pDent->d_name;
      if (sDirName != "." && sDirName != "..") {
        sDirName += "/";
        sDirName += sSearch;
        altStrList oBuf = GetFileList (sDirName, bRecursive);
        for (altUInt i = 0; i < oBuf.size(); i++) {
          oFileList.push_back (oBuf[i]);
        }
      }
    }
    // file
    else {
      oFileList.push_back (pDent->d_name);
    }
  }
  closedir (pDir);
#endif
  return (oFileList);
}

///
/// \brief  Get file list
///
/// \param  sSearch     [I ] Search
/// \param  bRecursive  [I ] Recursive or not
///
/// \return File list
///
LIBALT_API altWStrList altDir::GetFileList(const altWStr & sSearch, const altBool bRecursive, const altWStr & sDirPath) const
{
  altWStrList     oFileList;
#ifdef ALT_WIN
  static altUInt  nDepth = 0;
  WIN32_FIND_DATAW FindFileData;
  HANDLE hFind = FindFirstFileW ((LPCWSTR)sSearch.GetCStr(), & FindFileData);
  if (hFind == INVALID_HANDLE_VALUE) {
    return (oFileList);
  }
  
  do {
    altWStr sFileName = FindFileData.cFileName;
    if (sFileName != _T(".") && sFileName != _T("..")) {
      if (FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY && bRecursive) {
        altWStr sDirName = sDirPath + _T("/*.*");
        altWStr sDir = sDirPath;

        if (nDepth > 0) {
          sDirName = sDirPath + _T("/") + sFileName + _T("/*.*");
          sDir = sDirPath + _T("/") + sFileName;
        }
        else {
          sDirName = sDirPath + _T("/*.*");
          sDir = sDirPath;
        }

        nDepth++;
        altWStrList oBuf = GetFileList (sDirName, bRecursive, sDir);
        for (altUInt i = 0; i < oBuf.size(); i++) {
          oFileList.push_back (oBuf[i]);
        }
        nDepth--;
      }
      else {
        altWStr sFilePath = sDirPath + _T("/") + sFileName;
        oFileList.push_back (sFilePath);
      }
    }
  } while (FindNextFileW (hFind, & FindFileData));
#endif
#ifdef ALT_LINUX
  DIR *           pDir = opendir ((const char *)sSearch.GetCStr());
  struct dirent * pDent;
  if (pDir == NULL) {
    return (oFileList);
  }
  while ((pDent = readdir (pDir)) != NULL) {
    // directory
    if (pDent->d_type == DT_DIR && bRecursive) {
      altStr  sDirName = pDent->d_name;
      if (sDirName != "." && sDirName != "..") {
        sDirName += "/";
        sDirName += sSearch;
        altStrList oBuf = GetFileList (sDirName, bRecursive);
        for (altUInt i = 0; i < oBuf.size(); i++) {
          oFileList.push_back (oBuf[i]);
        }
      }
    }
    // file
    else {
      oFileList.push_back ((const altWChar *)pDent->d_name);
    }
  }
  closedir (pDir);
#endif
  return (oFileList);
}

///
/// \brief  Create Directory
///
/// \param  sSearch     [I ] Search
/// \param  bRecursive  [I ] Recursive or not
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altDir::Create(const altStr & sDirName, const altBool bRecursive)
{
  altBool bSuccess;

  if (bRecursive) {
    bSuccess = altMkDirR (sDirName.GetCStr());
  }
  else {
    bSuccess = altMkDir (sDirName.GetCStr());
  }

  if (! bSuccess) {
    ALT_RET (ALT_E_ERROR);
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Check Directory or not
///
/// \return true  Directory
/// \return false Not Directory
///
LIBALT_API altBool altDir::IsDir(const altStr & sDirName)
{
#ifdef ALT_WIN
  WIN32_FIND_DATAA FindFileData;
  HANDLE hFind = FindFirstFileA (sDirName.GetCStr(), & FindFileData);
  if (hFind == INVALID_HANDLE_VALUE) {
    return (false);
  }
  
  altStr  sFileName = FindFileData.cFileName;
  if (FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
    return (true);
  }

  return (false);
#endif
#ifdef ALT_LINUX
  DIR * pDir = opendir (sDirName.GetCStr());
  struct dirent * pDent;
  if (pDir == NULL) {
    return (false);
  }

  pDent = readdir (pDir);
  if (pDent->d_type == DT_DIR) {
    return (true);
  }
  return (false);
#endif
}

///
/// \brief  Check Directory or not
///
/// \return true  Directory
/// \return false Not Directory
///
LIBALT_API altBool altDir::IsDir(const altWStr & sDirName)
{
#ifdef ALT_WIN
  WIN32_FIND_DATAA FindFileData;
  HANDLE hFind = FindFirstFileW ((LPCWSTR)sDirName.GetCStr(), (LPWIN32_FIND_DATAW)& FindFileData);
  if (hFind == INVALID_HANDLE_VALUE) {
    return (false);
  }
  
  altStr  sFileName = FindFileData.cFileName;
  if (FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
    return (true);
  }

  return (false);
#endif
#ifdef ALT_LINUX
  DIR * pDir = opendir ((const char *)sDirName.GetCStr());
  struct dirent * pDent;
  if (pDir == NULL) {
    return (false);
  }

  pDent = readdir (pDir);
  if (pDent->d_type == DT_DIR) {
    return (true);
  }
  return (false);
#endif
}
