#ifndef ALTDIR_H
#define ALTDIR_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDir.h 1415 2008-10-24 22:09:32Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altDir.h
 * \brief   Directory
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStr.h>
#include <altBase/altLog.h>

#ifdef ALT_LINUX
#include <dirent.h>
#endif

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Directory
///
class altDir : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDir();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDir();

  ///
  /// \brief  Get file list
  ///
  /// \param  sSearch     [I ] Search
  /// \param  bRecursive  [I ] Recursive or not
  ///
  /// \return File list
  ///
  LIBALT_API altStrList GetFileList(const altStr & sSearch = "*.*", const altBool bRecursive = true, const altStr & sDirPath = "") const;
  
  ///
  /// \brief  Get file list
  ///
  /// \param  sSearch     [I ] Search
  /// \param  bRecursive  [I ] Recursive or not
  ///
  /// \return File list
  ///
  LIBALT_API altWStrList GetFileList(const altWStr & sSearch, const altBool bRecursive, const altWStr & sDirPath) const;

  ///
  /// \brief  Create Directory
  ///
  /// \param  sSearch     [I ] Search
  /// \param  bRecursive  [I ] Recursive or not
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Create(const altStr & sDirName, const altBool bRecursive = true);

  ///
  /// \brief  Check Directory or not
  ///
  /// \return true  Directory
  /// \return false Not Directory
  ///
  LIBALT_API altBool IsDir(const altStr & sDirName);

  ///
  /// \brief  Check Directory or not
  ///
  /// \return true  Directory
  /// \return false Not Directory
  ///
  LIBALT_API altBool IsDir(const altWStr & sDirName);
};

#endif
