#ifndef ALTMISCUTIL_H
#define ALTMISCUTIL_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altMiscUtil.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altMiscUtil.h
 * \brief   Utility Function
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Function Declare
 *----------------------------------------------------------------*/
///
/// \brief  Hex to DWORD
///
/// \param  szHex   [I ] Hex string
///
/// \return DWORD value
///
LIBALT_API DWORD altHexToDWORD(const altChar * szHex);

///
/// \brief  fputs
///
/// \param  szStr [I ] String
/// \param  pFile [I ] FILE pointer
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_WRITE   write error
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altFPuts(const altChar * szData, FILE * pFile);

///
/// \brief  fputs
///
/// \param  szStr [I ] String
/// \param  pFile [I ] FILE pointer
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_WRITE   write error
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altFPutsW(const altWChar * szData, FILE * pFile);

#endif
