/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altProccess.cpp 1370 2008-04-25 06:05:20Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altProccess.cpp
 * \brief   Proccess
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altProccess.h"
#include "altBase/altSignal.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altProccess::altProccess()
{
}

///
/// \brief  Destructor
///
LIBALT_API altProccess::~altProccess()
{
}

#ifdef ALT_LINUX
///
/// \brief  daemon
///
/// \return ALT_S_SUCCESS
/// \return ALT_E_ERROR
///
alt_t altProccess::Deamon()
{
  switch (fork()) {
    case  -1:
      ALT_RET_P (ALT_E_ERROR, strerror (errno));
    case  0:
      setsid();
      break;
    default:
      exit (0);
  }

  altSignal::Ignore (SIGCHLD);
  altSignal::Ignore (SIGHUP);
  altSignal::Ignore (SIGPIPE);
  altSignal::Ignore (SIGTERM);

  umask (0);
  ALT_RET (ALT_S_SUCCESS);
}
#endif

