#ifndef ALTPROCCESS_H
#define ALTPROCCESS_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altProccess.h 1373 2008-04-25 06:18:13Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altProccess.h
 * \brief   Proccess
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#include <altBase/altLog.h>

#ifdef ALT_LINUX
  #include <sys/types.h>
  #include <sys/stat.h>
#endif

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Proccess
///
class altProccess : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altProccess();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altProccess();

#ifdef ALT_LINUX
  ///
  /// \brief  daemon
  ///
  /// \return ALT_S_SUCCESS
  /// \return ALT_E_ERROR
  ///
  LIBALT_API static alt_t Deamon();
#endif

};

#endif
