#ifndef ALTSHA1_H
#define ALTSHA1_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSHA1.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altSHA1.h
 * \brief   SHA1
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStr.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>

#ifdef ALT_WIN
#include <altNet/openssl/sha.h>
#endif
#ifdef ALT_LINUX
#include <openssl/sha.h>
#endif

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  SHA1
///
class altSHA1 : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSHA1();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altSHA1();

  ///
  /// \brief  Update SHA1 digest
  ///
  /// \param  pData [I ] Data
  /// \param  nSize [I ] Data size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Update(const altUChar * pData, const altUInt nSize);

  ///
  /// \brief  To string
  ///
  /// \return string
  ///
  LIBALT_API altStr ToStr();

  altUChar  m_aHash[SHA_DIGEST_LENGTH]; ///< SHA1 digest
};

#endif
