#ifndef ALTWINMUTEX_H
#define ALTWINMUTEX_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altWinMutex.h 1267 2008-04-10 23:03:53Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altWinMutex.h
 * \brief   Mutex
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStr.h>
#include <altBase/altLog.h>
#ifdef ALT_WIN
/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  File
///
class altWinMutex : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altWinMutex();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altWinMutex();

  ///
  /// \brief  Create Mutex
  ///
  /// \param  sName   [I ] Mutex Name
  /// \param  bOwner  [I ] Owner
  ///
  /// \return ALT_S_SUCCESS     success
  /// \return ALT_S_MUTEX_EXIST exist
  /// \return ALT_E_ERROR       error
  ///
  LIBALT_API alt_t Create(const altStr & sName, altBool bOwner = true);

  ///
  /// \brief  Open Mutex
  ///
  /// \param  sName     [I ] Mutex Name
  /// \param  dwAccess  [I ] Access (SYNCHRONIZE or MUTEX_ALL_ACCESS)
  /// \param  bInherit  [I ] Inherit
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Open(const altStr & sName, DWORD dwAccess = SYNCHRONIZE, altBool bInherit = true);

  ///
  /// \brief  Close Mutex
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Close();

  ///
  /// \brief  Release Mutex
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Release();

  ///
  /// \brief  Wait
  ///
  /// \param  dwMilliseconds  [I ] Timeout
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_S_TIMEOUT timeout
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Wait(DWORD dwMilliseconds = 1000);

private:
  HANDLE  m_hMutex;   ///< Mutex Handle
};


#endif
#endif
