#ifndef ALTNEKOACCEPTOR_H
#define ALTNEKOACCEPTOR_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOAcceptor.h 951 2008-03-03 10:43:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOAcceptor.h
 * \brief   NEKO Network Server Acceptor
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOReceiver.h>
#include <altNeko/altNEKOSender.h>
#include <altNet/altSSLAcceptor.h>
#include <altNet/altTCPSocket.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
///
/// \brief  Accept call back function
///
/// \param  nPort           [I ] Port number
/// \param  pNEKOConnection [I ] Accepted connection
///
typedef alt_t (* altNEKOAcceptCallBack)(const altInt nPort, const altCNEKOConnectionPtr & pNEKOConnection);

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NEKO network acceptor class
///
class altNEKOAcceptor : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  pReceiveCallBack    [I ] receive call back function
  /// \param  nThreadCount        [I ] Reqeust Thread Count
  /// \param  nAcceptThreadCount  [I ] Accept Thread Count
  /// \param  nSSLVersion         [I ] SSL Version (ALT_NO_SSL or ALT_SSL_V23 or ALT_SSL_V2 or ALT_SSL_V3 or ALT_TSL_V1)
  ///
  LIBALT_API altNEKOAcceptor(const altNEKOReceiveCallBack pReceiveCallBack, const altUInt nThreadCount, const altUInt nAcceptThreadCount, const altByte nSSLVersion);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKOAcceptor();

  ///
  /// \brief  Open Port
  ///
  /// \param  nPort               [I ] Port NO
  /// \param  nListenQueSize      [I ] Listen Queue Size
  /// \param  pAcceptCallBack     [I ] Accept Call Back Function
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_INVAL     parameter error
  /// \return ALT_E_SOCKET    create socket error
  /// \return ALT_E_BIND      bind error
  /// \return ALT_E_LISTEN    listen error
  ///
  LIBALT_API virtual alt_t OpenPort(const altInt nPort, const altInt nListenQueSize, const altNEKOAcceptCallBack pAcceptCallBack);

  ///
  /// \brief  Close Port
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t ClosePort();

  ///
  /// \brief  Get port number
  ///
  /// \return Port number
  ///
  LIBALT_API altInt GetPortNo() const;

  ///
  /// \brief  Get sender packet count
  ///
  /// \return Sender packet count
  ///
  LIBALT_API altUInt GetSenderPacketCount() const;

  ///
  /// \brief  Get receiver packet count
  ///
  /// \return Receiver packet count
  ///
  LIBALT_API altUInt GetReceiverPacketCount() const;

protected:
  ///
  /// \brief  Accept Thread
  ///
  /// \param  pParam  [I ] parameter
  ///
  LIBALT_API static alt_t TCPAcceptThread(void * pParam);

  ///
  /// \brief  Accept Thread
  ///
  /// \param  pParam  [I ] parameter
  ///
  LIBALT_API static alt_t SSLAcceptThread(void * pParam);

  altNEKOReceiver           m_oReceiver;              ///< Receiver
  altNEKOSender             m_oSender;                ///< Sender
  altByte                   m_nSSLVersion;            ///< SSL Version
  altTCPSocket              m_nListenSocket;          ///< Listen socket
  altNEKOAcceptCallBack     m_pAcceptCallBackFunc;    ///< Accept call back function
  altInt                    m_nPort;                  ///< port no
  altUInt                   m_nAcceptThreadCount;     ///< Accept Thread Count
  altAcceptThreadContainer  m_oAcceptThreadContainer; ///< Accept Thread Container
};

#endif
