#ifndef ALTNEKOCONNECTION_H
#define ALTNEKOCONNECTION_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOConnection.h 1391 2008-05-01 18:07:37Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOConnection.h
 * \brief   NEKO Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOSocket.h>
#include <altNeko/altNEKOSender.h>
#include <altBase/altDataStream.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altNEKOSender;
class altNEKOConnection;
typedef const altNEKOConnection     altCNEKOConnection;     ///< const altNETConnection
typedef altPtr<altNEKOConnection>   altNEKOConnectionPtr;   ///< pointer of altNEKOConnection
typedef altPtr<altCNEKOConnection>  altCNEKOConnectionPtr;  ///< pointer of const altNEKOConnection

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NEKO Network Connection Class
///
class altNEKOConnection : public altBase, public altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  pSSL            [I ] Pointer of SSL Object
  /// \param  m_pSSLContext   [I ] Pointer of SSL Context Object
  /// \param  nSocket         [I ] Socket
  /// \param  oSockAddrIn     [I ] Internet Address of Socket
  /// \param  nAcceptedPortNo [I ] Accepted Port Number
  /// \param  oSender         [I ] Sender
  /// \param  nSSLVersion     [I ] SSL Version (ALT_NO_SSL or ALT_SSL_V23 or ALT_SSL_V2 or ALT_SSL_V3 or ALT_TSL_V1)
  ///
  LIBALT_API altNEKOConnection(SSL * pSSL, SSL_CTX * pSSLContext, const SOCKET nSocket, const SOCKADDR_IN & oSockAddrIn, const altInt nAcceptedPortNo, altNEKOSender & oSender, const altByte nSSLVersion);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKOConnection();

  ///
  /// \brief  Get Socket
  ///
  /// \return Socket
  ///
  LIBALT_API const SOCKET GetSocket() const;
  
  ///
  /// \brief Get IP Address
  ///
  /// \return IP Address
  ///
  LIBALT_API virtual const altStr GetIP() const;

  ///
  /// \brief Get Port NO
  ///
  /// \return Port NO
  ///
  LIBALT_API virtual altInt GetPort() const;

  ///
  /// \brief  Get accepted port number
  ///
  /// \return Accepted port number
  ///
  LIBALT_API const altInt GetAcceptedPort() const;

  ///
  /// \brief  Close Socket
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t virtual Close();

  ///
  /// \brief  Read Data
  ///
  /// \param  pData [ O] receive data
  /// \param  nSize [IO] receive data size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_S_NET_EOF   connection closed
  /// \return ALT_S_TIMEOUT   timeout
  /// \return ALT_E_NOMEM     out of memory error
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t virtual Recv(altCharPtr & pData, altUInt & nSize) const;

  ///
  /// \brief  Send Data
  ///
  /// \param  pData [I ] send data
  /// \param  nSize [I ] send data size
  ///
  /// \return ALT_S_SUCCESS   successs
  /// \return ALT_E_NOMEM     out of memory
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Send(const altCharPtr & pData, const altInt nSize) const;

  ///
  /// \brief  Send Data
  ///
  /// \param  sRemoteFuncName [I ] Remote function name
  /// \param  oDataStream     [I ] Send data
  ///
  /// \return ALT_S_SUCCESS   successs
  /// \return ALT_E_NOMEM     out of memory
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Send(const altStr & sRemoteFuncName, const altDataStream & oDataStream) const;

  ///
  /// \brief  Real Send Data
  ///
  /// \param  pData [I ] send data
  /// \param  nSize [I ] send data size
  ///
  /// \return ALT_S_SUCCESS   successs
  /// \return ALT_E_SEND      send error
  ///
  LIBALT_API virtual alt_t RealSend(const altCharPtr & pData, const altInt nSize) const;

  ///
  /// \brief  Get connecting or not
  ///
  /// \return true  connecting
  /// \return false not connecting
  ///
  LIBALT_API altBool Connected() const;

  ///
  /// \brief  Get server connection or not
  ///
  /// \return true  server connection
  /// \return false client connection
  ///
  LIBALT_API altBool IsServerConnection() const;

public:
  mutable altBool               m_bServer;            ///< Is Server Connection or not
protected:
  altNEKOSocket                 m_oSocket;            ///< Socket
  altInetAddress                m_oSockAddrIn;        ///< Internet address
  altInt                        m_nAcceptedPortNo;    ///< Accepted port number
  mutable altNEKOSender &       m_oSender;            ///< Sender
  altBool                       m_bServerConnection;  ///< Server connection or not
  mutable altULongLong          m_nSendPacketID;      ///< Send packet ID
  mutable altULongLong          m_nRecvPacketID;      ///< Receive packet ID
};

#endif
