#ifndef ALTNEKOCONNECTIONMANAGER_H
#define ALTNEKOCONNECTIONMANAGER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOConnectionManager.h 1394 2008-05-01 19:10:17Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOConnectionManager.h
 * \brief   NEKO Network Connection Manager
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNeko/altNEKOConnection.h>
#include <altNeko/altNEKOReceiver.h>
#include <altNet/altNETServerInfo.h>
#include <altNet/altNetUtil.h>
#include <altBase/altStr.h>
#include <altBase/altPtr.h>
#include <altBase/altLog.h>
#include <altBase/altSingleton.h>

#include <map>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get Instance
///
#define aiNEKOConnectionManager altNEKOConnectionManager::GetInstance()

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altNEKOReceiver;
typedef std::map<SOCKET, altCNEKOConnectionPtr>   altNEKOConnectionMap;       ///< Map of altCNETConnectionPtr
typedef std::map<altStr, altCNEKOConnectionPtr>   altNEKOServerConnectionMap; ///< Map of Server Connection
typedef std::map<altInt, altNEKOReceiver *>       altNEKOReceiverMap;         ///< NEKO Receiver Broker Map
typedef std::map<altStr, altNETServerInfo *>      altNETServerInfoMap;        ///< Map of server infomation

///
/// \brief  Disconnect call back function
///
/// \param  pNEKOConnection [I ] Disconnected connection
///
typedef alt_t (* altNEKODisconnectCallBackFunc)(const altCNEKOConnectionPtr &);

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NEKO network Connection Manager Class
///
class altNEKOConnectionManager : public altSingleton<altNEKOConnectionManager>, private altSyncThread
{
friend class altSingleton<altNEKOConnectionManager>;
protected:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altNEKOConnectionManager();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNEKOConnectionManager();

public:
  ///
  /// \brief  Set Disconnected Call Back Function
  ///
  /// \param  pDisconnectedFunc [I ] Disconnected Call Back Function
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetDisconnectedCallBackFunc(altNEKODisconnectCallBackFunc pDisconnectedFunc);

  ///
  /// \brief  Add Connection
  ///
  /// \param  pConnection   [I ] Pointer of NET Connection
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Add(const altCNEKOConnectionPtr & pConnection);

  ///
  /// \brief  Delete Connection
  ///
  /// \param  pConnection   [I ] Pointer of NET Connection
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Del(const altCNEKOConnectionPtr & pConnection);

  ///
  /// \brief  Set to Server Connection
  ///
  /// \param  sServerName   [I ] Server Name
  /// \param  pConnection   [I ] Pointer of NET Connection
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetToServerConnection(const altStr & sServerName, const altCNEKOConnectionPtr & pConnection);

  ///
  /// \brief  Get server connection
  ///
  /// \param  sServerName   [I ] Server Name
  ///
  /// \return Get server connection
  ///
  LIBALT_API const altCNEKOConnectionPtr & GetServerConnection(const altStr & sServerName);

  ///
  /// \brief  Get Connection Count
  ///
  /// \return Connection Count
  ///
  LIBALT_API altUInt Size() const;
  
  ///
  /// \brief  Add NET Receiver Broker
  ///
  /// \param  nPort           [I ] Port Number
  /// \param  altNEKOReceiver [I ] Pointer of NEKO Receiver
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t Add(const altInt nPort, altNEKOReceiver * pNEKOReceiver);

  ///
  /// \brief  Delete NET Receiver Broker
  ///
  /// \param  nPort [I ] Port Number
  ///
  LIBALT_API void DeletePort(const altInt nPort);

  ///
  /// \brief  Close all client connection
  ///
  LIBALT_API void CloseAllClientConnection();

private:
  altNEKOConnectionMap          m_oClientConnectionMap;       ///< Client connection map
  altNEKOServerConnectionMap    m_oServerConnectionMap;       ///< Server connection map
  altNEKOReceiverMap            m_oNEKOReceiverMap;           ///< Receiver map
  altNEKODisconnectCallBackFunc m_pDisconnectedCallBackFunc;  ///< Disconnected call back function
  altNETServerInfoMap           m_oServerInfoMap;             ///< Server infomation map
};
#endif  //ALTNEKOCONNECTIONMANAGER_H
