/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNEKOMonitorLogger.cpp 1358 2008-04-21 03:23:18Z nekosys $

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altNEKOMonitorLogger.cpp
 * \brief   NEKO Network Monitor Logger
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altNEKOMonitorLogger.h"
#include "altNEKOServer.h"
#include "altBase/altDateTime.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altNEKOMonitorLogger::altNEKOMonitorLogger() :
m_oLoopThread(),
m_nPort (0),
m_bHeader (false)
{
}

///
/// \brief  Destructor
///
LIBALT_API altNEKOMonitorLogger::~altNEKOMonitorLogger()
{
  Close();
}

///
/// \brief  Start
///
/// \param  sFileName [I ] File Name
/// \param  nPort     [I ] Port NO
/// \param  bHeader   [I ] Print Header or Not
/// \param  nInterval [I ] Write interval (msec)
///
/// \return ALT_S_SUCCESS   success
///
LIBALT_API alt_t altNEKOMonitorLogger::Start(const altStr & sFileName, altInt nPort, altBool bHeader, DWORD nInterval)
{
  alt_t status;

  status = Open (sFileName);
  ALT_ERR_RET (status);

  m_nPort = nPort;
  m_bHeader = bHeader;

  m_oLoopThread.SetInterval (nInterval);
  m_oLoopThread.Start (altNEKOMonitorLogger::WriteThread, this);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Stop
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altNEKOMonitorLogger::Stop()
{
  m_oLoopThread.StopNoWait();
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Memory log write thread
///
/// \param  pParam  [I ] this object
///
LIBALT_API alt_t altNEKOMonitorLogger::WriteThread(void * pParam)
{
  altNEKOMonitorLogger * pLogger = (altNEKOMonitorLogger *)pParam;
  alt_t status;

  status = pLogger->Write();
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Open log file
///
/// \param  sFileName [I ] file name
/// \param  sMode     [I ] file open mode
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altNEKOMonitorLogger::Open(const altStr & sFileName, const altStr & sMode)
{
  if (altBaseLog::Open (sFileName, sMode) == false) {
    ALT_RET (ALT_E_ERROR);
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Write to log file
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altNEKOMonitorLogger::Write()
{
  static  altUInt  nCount = 0;
  altStr      sLine;
  altDateTime oNow;

  altBaseLog::OpenFile (altBaseLog::m_sMode);
  if (m_bHeader && nCount % 10 == 0) {
    altStr  sHeader;
    sHeader.Format ("%s\t%10s\t%10s\t%10s\n", oNow.Format ("YYYY/MM/DD HH:MI").GetCStr(), "Connection", "Send", "Receive");
    fputs (sHeader.GetCStr(), altBaseLog::m_pOut);
    nCount = 0;
  }

  sLine.Format ("%s\t%10u\t%10u\t%10u\n", oNow.Format ("YYYY/MM/DD HH:MI").GetCStr(), aiNEKOServer.GetConnectionCount(), aiNEKOServer.GetSenerPacketCount (m_nPort), aiNEKOServer.GetReceiverPacketCount (m_nPort));
  fputs (sLine.GetCStr(), altBaseLog::m_pOut);

  if (m_bHeader) {
    nCount++;
  }
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Close log file
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altNEKOMonitorLogger::Close()
{
  altBaseLog::Close();
  ALT_RET (ALT_S_SUCCESS);
}

